/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.packageresolver.FeatureSetRule;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ImmutableFeatureSetRule
implements FeatureSetRule {
    private final VersionRange versionRange;
    private final Set<Feature> features;

    private ImmutableFeatureSetRule(VersionRange versionRange, Set<Feature> features) {
        this.versionRange = versionRange;
        this.features = features;
    }

    @Override
    public VersionRange versionRange() {
        return this.versionRange;
    }

    @Override
    public Set<Feature> features() {
        return this.features;
    }

    public final ImmutableFeatureSetRule withVersionRange(VersionRange value) {
        if (this.versionRange == value) {
            return this;
        }
        VersionRange newValue = Objects.requireNonNull(value, "versionRange");
        return new ImmutableFeatureSetRule(newValue, this.features);
    }

    public final ImmutableFeatureSetRule withFeatures(Feature ... elements) {
        Set<Feature> newValue = ImmutableFeatureSetRule.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableFeatureSetRule(this.versionRange, newValue);
    }

    public final ImmutableFeatureSetRule withFeatures(Iterable<Feature> elements) {
        if (this.features == elements) {
            return this;
        }
        Set<Feature> newValue = ImmutableFeatureSetRule.createUnmodifiableEnumSet(elements);
        return new ImmutableFeatureSetRule(this.versionRange, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeatureSetRule && this.equalsByValue((ImmutableFeatureSetRule)another);
    }

    private boolean equalsByValue(ImmutableFeatureSetRule another) {
        return this.versionRange.equals(another.versionRange) && this.features.equals(another.features);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.versionRange.hashCode();
        h += (h << 5) + this.features.hashCode();
        return h;
    }

    public String toString() {
        return "FeatureSetRule{versionRange=" + this.versionRange + ", features=" + this.features + "}";
    }

    public static ImmutableFeatureSetRule copyOf(FeatureSetRule instance) {
        if (instance instanceof ImmutableFeatureSetRule) {
            return (ImmutableFeatureSetRule)instance;
        }
        return ((Builder)((Builder)ImmutableFeatureSetRule.builder()).versionRange(instance.versionRange()).addAllFeatures(instance.features())).build();
    }

    public static VersionRangeBuildStage builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<? extends T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableFeatureSetRule.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    public static interface BuildFinal {
        public BuildFinal addFeatures(Feature var1);

        public BuildFinal addFeatures(Feature ... var1);

        public BuildFinal addAllFeatures(Iterable<Feature> var1);

        public ImmutableFeatureSetRule build();
    }

    public static interface VersionRangeBuildStage {
        public BuildFinal versionRange(VersionRange var1);
    }

    public static final class Builder
    implements VersionRangeBuildStage,
    BuildFinal {
        private static final long INIT_BIT_VERSION_RANGE = 1L;
        private long initBits = 1L;
        private VersionRange versionRange;
        private final EnumSet<Feature> features = EnumSet.noneOf(Feature.class);

        private Builder() {
        }

        @Override
        public final Builder versionRange(VersionRange versionRange) {
            Builder.checkNotIsSet(this.versionRangeIsSet(), "versionRange");
            this.versionRange = Objects.requireNonNull(versionRange, "versionRange");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder addFeatures(Feature element) {
            this.features.add(Objects.requireNonNull(element, "features element"));
            return this;
        }

        @Override
        public final Builder addFeatures(Feature ... elements) {
            for (Feature element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        @Override
        public final Builder addAllFeatures(Iterable<Feature> elements) {
            for (Feature element : elements) {
                this.features.add(Objects.requireNonNull(element, "features element"));
            }
            return this;
        }

        @Override
        public ImmutableFeatureSetRule build() {
            this.checkRequiredAttributes();
            return new ImmutableFeatureSetRule(this.versionRange, ImmutableFeatureSetRule.createUnmodifiableEnumSet(this.features));
        }

        private boolean versionRangeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of FeatureSetRule is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.versionRangeIsSet()) {
                attributes.add("versionRange");
            }
            return "Cannot build FeatureSetRule, some of required attributes are not set " + attributes;
        }
    }
}

