/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.ImmutableVersionRange;
import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import org.immutables.value.Value;

@Value.Immutable
public abstract class VersionRange
implements DistributionMatch {
    @Value.Parameter
    abstract NumericVersion min();

    @Value.Parameter
    abstract NumericVersion max();

    @Value.Check
    protected void check() {
        if (this.min().compareTo(this.max()) > 0) {
            throw new IllegalArgumentException(this.min() + " > " + this.max());
        }
    }

    @Override
    @Value.Auxiliary
    public boolean match(Distribution distribution) {
        return this.match(distribution.version());
    }

    @Value.Auxiliary
    public boolean match(Version version) {
        NumericVersion asNumeric = NumericVersion.of(version.asInDownloadPath());
        return this.min().isOlderOrEqual(asNumeric) && asNumeric.isOlderOrEqual(this.max());
    }

    public static VersionRange of(NumericVersion min, NumericVersion max) {
        return ImmutableVersionRange.of(min, max);
    }

    public static VersionRange of(String min, String max) {
        return VersionRange.of(NumericVersion.of(min), NumericVersion.of(max));
    }

    public static VersionRange of(String minMax) {
        return VersionRange.of(NumericVersion.of(minMax), NumericVersion.of(minMax));
    }
}

