/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import java.util.HashMap;
import java.util.Map;

public enum OpCode {
    OP_REPLY(1),
    OP_UPDATE(2001),
    OP_INSERT(2002),
    RESERVED(2003),
    OP_QUERY(2004),
    OP_GET_MORE(2005),
    OP_DELETE(2006),
    OP_KILL_CURSORS(2007),
    OP_MSG(2013);

    private final int id;
    private static final Map<Integer, OpCode> byIdMap;

    private OpCode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static OpCode getById(int id) {
        return byIdMap.get(id);
    }

    static {
        byIdMap = new HashMap<Integer, OpCode>();
        for (OpCode opCode : OpCode.values()) {
            byIdMap.put(opCode.id, opCode);
        }
    }
}

