/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.exception;

import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.ErrorCode;
import de.bwaldvogel.mongo.exception.MongoServerError;

public class IndexKeySpecsConflictException
extends MongoServerError {
    private static final long serialVersionUID = 1L;

    public IndexKeySpecsConflictException(Index<?> requestedIndex, Index<?> existingIndex) {
        super(ErrorCode.IndexKeySpecsConflict, "An existing index has the same name as the requested index. When index names are not specified, they are auto generated and can cause conflicts. Please refer to our documentation. Requested index: " + IndexKeySpecsConflictException.toJson(requestedIndex) + ", existing index: " + IndexKeySpecsConflictException.toJson(existingIndex));
    }

    private static String toJson(Index<?> index) {
        return Json.toCompactJsonValue(index.toIndexDescription());
    }
}

