/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Cursor;
import de.bwaldvogel.mongo.exception.CursorNotFoundException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class CursorRegistry {
    private final ConcurrentMap<Long, Cursor> cursors = new ConcurrentHashMap<Long, Cursor>();
    private final AtomicLong cursorIdCounter = new AtomicLong();

    public long generateCursorId() {
        return this.cursorIdCounter.incrementAndGet();
    }

    public Cursor getCursor(long cursorId) {
        Cursor cursor = (Cursor)this.cursors.get(cursorId);
        if (cursor == null) {
            throw new CursorNotFoundException(cursorId);
        }
        return cursor;
    }

    public boolean remove(Cursor cursor) {
        return this.remove(cursor.getId());
    }

    public boolean remove(long cursorId) {
        return this.cursors.remove(cursorId) != null;
    }

    public void add(Cursor cursor) {
        Cursor previousValue = this.cursors.put(cursor.getId(), cursor);
        Assert.isNull(previousValue);
    }

    public int size() {
        return this.cursors.size();
    }
}

