# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

import modules.barchart

# Uncomment during development. This will reload the module that is otherwise cached.
# reload(modules.barchart)

## Main
if __name__ in ['__builtin__', '__main__']:
    events = test_runs.getEventsForTestRun(test_run, {'@tags': tags})

    bar_chart = modules.barchart.BarChart(events, query_parameters)
    bar_chart.calculate()

    if bar_chart.at_top_level():
        title = 'Passed versus failed tests from latest test run in time window'
    else:
        title = 'Passed versus failed tests from latest test run in time window at level %s' % bar_chart.get_level()

    rotation = -45

    result_holder.result = {
        'chart': {
            'type': 'column'
        },
        'title': title,
        'description': 'This report presents the aggregated functional results of a test specification. It shows the latest test run in the selected time window. Click the graph to see results on a different level of the test hierarchy.',
        'xAxis': {
            'categories': bar_chart.get_categories(),
            'labels': {
                'rotation': rotation,
            }
        },
        'yAxis': {
            'min': 0,
            'title': {
                'text': 'Number of tests',
                'style': {
                    'color': '#666',
                    'font-weight': 'normal'
                }
            },
            'minTickInterval': 1
        },
        'legend': {
            'borderColor': None,
            'symbolHeight': 16,
            'symbolWidth': 16
        },
        'plotOptions': {
            'column': {
                'animation': False,
                'cursor': 'pointer',
                'borderRadius': 2,
                'groupPadding': 0.1,
                'pointPadding': 0.01
            },
            'series': {
                'point': {
                    'events': {
                        'click': 'url'
                    }
                }
            }
        },
        'series': [{
            'name': "Passed ({0})".format(bar_chart.get_passed_result_count()),
            'data': bar_chart.get_passed_results()
        }, {
            'name': "Failed ({0})".format(bar_chart.get_failed_result_count()),
            'data': bar_chart.get_failed_results()
        }, {
            'name': "Other ({0})".format(bar_chart.get_other_result_count()),
            'data': bar_chart.get_other_results()
        }]
    }
