# NOTE: Please do not edit this file directly
# Create your custom modules in the 'ext' folder

from modules.hierarchy import *

# For testing:
if __name__ in ['__builtin__', '__main__']:
    import sys
    sys.path.append(module_path)


class BarChart(object):
    def __init__(self, events, query_parameters):
        self._events = events
        self._query_parameters = query_parameters
        self._can_drill_down_result = None
        self._prefixArray = get_prefix_array(self._query_parameters)
        self._passed = {}
        self._failed = {}
        self._other = {}
        self._categories = {}

    def _make_column_values(self, counts):
        return map(lambda category: counts.get(category, 0) > 0 and {'y': counts[category], 'params': {'prefix': ';'.join(self._prefixArray + [category])}} or {'y': 0}, self._categories)

    @staticmethod
    def _count_values(results):
        return reduce(lambda x, y: x + y, map(lambda r: r['y'], results), 0)

    def calculate(self):
        for ev in self._events:
            if is_functional_result(ev) and prefix_within_hierarchy(ev, self._prefixArray):
                node = next_node_in_hierarchy(ev, self._prefixArray)

                if self._can_drill_down_result is None:
                    self._can_drill_down_result = can_drill_down(ev, self._prefixArray)

                if node is None:
                    continue

                result = ev.get('@result')

                if result == 'PASSED':
                    self._passed[node] = self._passed.get(node, 0) + 1
                elif result == 'OTHER':
                    self._other[node] = self._other.get(node, 0) + 1
                else:
                    self._failed[node] = self._failed.get(node, 0) + 1

        self._categories = sorted(set(self._failed.keys() + self._passed.keys() + self._other.keys()))

        # prevent ability to drill down over the edge
        if self._can_drill_down_result is False:
            self._prefixArray = self._prefixArray[:-1]

        # Rework our data for representation (to highcharts format)
        self._passed = self._make_column_values(self._passed)
        self._failed = self._make_column_values(self._failed)
        self._other = self._make_column_values(self._other)

    def get_categories(self):
        return self._categories

    def get_passed_results(self):
        return self._passed

    def get_passed_result_count(self):
        return self._count_values(self._passed)

    def get_failed_results(self):
        return self._failed

    def get_failed_result_count(self):
        return self._count_values(self._failed)

    def get_other_results(self):
        return self._other

    def get_other_result_count(self):
        return self._count_values(self._other)

    def get_level(self):
        return len(self._prefixArray)

    def at_top_level(self):
        return self.get_level() == 0


# For testing:
if __name__ in ['__builtin__', '__main__']:
    bar_chart = BarChart(events, query_parameters)
    result_holder.result = {
        'chart': {
            'type': 'column'
        },
        'title': title,
        'description': 'This report presents the tests that passed and failed during the last execution of the test specification.',
        'xAxis': {
            'categories': bar_chart.get_categories(),
            'labels': {
                'rotation': -45,
            }
        },
        'yAxis': {
            'min': 0,
            'title': {
                'text': 'Number of tests',
                'style': {
                    'color': '#666',
                    'font-weight': 'normal'
                }
            },
            'minTickInterval': 1
        },
        'legend': {
            'borderColor': None,
            'symbolHeight': 16,
            'symbolWidth': 16
        },
        'plotOptions': {
            'column': {
                'animation': False,
                'cursor': 'pointer',
                'borderRadius': 2,
                'groupPadding': 0.1,
                'pointPadding': 0.01
            },
            'series': {
                'point': {
                    'events': {
                        'click': 'url'
                    }
                }
            }
        },
        'series': [{
            'name': "Passed ({0})".format(bar_chart.get_passed_result_count()),
            'data': bar_chart.get_passed_results()
        }, {
            'name': "Failed ({0})".format(bar_chart.get_failed_result_count()),
            'data': bar_chart.get_failed_results()
        }, {
            'name': "Other ({0})".format(bar_chart.get_other_result_count()),
            'data': bar_chart.get_other_results()
        }]
    }
