/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SecurityActions;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NumericVersionGenerator
implements VersionGenerator {
    private static final Log log = LogFactory.getLog(NumericVersionGenerator.class);
    final AtomicInteger versionCounter = new AtomicInteger();
    final AtomicLong versionPrefix = new AtomicLong();
    private static final NumericVersion NON_EXISTING = new NumericVersion(0L);
    private Cache<?, ?> cache;
    private boolean isClustered;

    @Inject
    public void init(Cache<?, ?> cache) {
        this.cache = cache;
    }

    @Start(priority=11)
    public void start() {
        SecurityActions.addCacheManagerListener(this.cache.getCacheManager(), new RankCalculator());
        this.isClustered = SecurityActions.getCacheConfiguration(this.cache.getAdvancedCache()).clustering().cacheMode().isClustered();
        if (this.isClustered) {
            ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(this.cache.getAdvancedCache());
            Transport transport = componentRegistry.getGlobalComponentRegistry().getComponent(Transport.class);
            this.calculateRank(transport.getAddress(), transport.getMembers(), transport.getViewId());
        }
    }

    public NumericVersionGenerator clustered(boolean clustered) {
        this.isClustered = clustered;
        return this;
    }

    @Override
    public IncrementableEntryVersion generateNew() {
        long counter = this.versionCounter.incrementAndGet();
        return this.createNumericVersion(counter);
    }

    private IncrementableEntryVersion createNumericVersion(long counter) {
        return this.isClustered ? new NumericVersion(this.versionPrefix.get() | counter) : new NumericVersion(counter);
    }

    @Override
    public IncrementableEntryVersion increment(IncrementableEntryVersion initialVersion) {
        if (initialVersion instanceof NumericVersion) {
            NumericVersion old = (NumericVersion)initialVersion;
            long counter = old.getVersion() + 1L;
            return this.createNumericVersion(counter);
        }
        throw log.unexpectedInitialVersion(initialVersion.getClass().getName());
    }

    @Override
    public IncrementableEntryVersion nonExistingVersion() {
        return NON_EXISTING;
    }

    long calculateRank(Address address, List<Address> members, long viewId) {
        long rank = this.findAddressRank(address, members, 1);
        long newVersionPrefix = viewId << 48 | rank << 32;
        this.versionPrefix.compareAndSet(this.versionPrefix.get(), newVersionPrefix);
        return this.versionPrefix.get();
    }

    void resetCounter() {
        this.versionCounter.set(0);
    }

    private int findAddressRank(Address address, List<Address> members, int rank) {
        if (address.equals(members.get(0))) {
            return rank;
        }
        return this.findAddressRank(address, members.subList(1, members.size()), rank + 1);
    }

    @Listener
    public class RankCalculator {
        @ViewChanged
        public void calculateRank(ViewChangedEvent e) {
            long rank = NumericVersionGenerator.this.calculateRank(e.getLocalAddress(), e.getNewMembers(), e.getViewId());
            if (log.isTraceEnabled()) {
                log.tracef("Calculated rank based on view %s and result was %d", e, rank);
            }
        }
    }
}

