/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryEnvironment;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.NodeCacheIterator;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.TransactionalWorkspaceCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactories;

public abstract class AbstractSessionCache
implements SessionCache,
DocumentCache {
    private final WorkspaceCache sharedWorkspaceCache;
    private final AtomicReference<WorkspaceCache> workspaceCache = new AtomicReference();
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final Path rootPath;
    private final RepositoryEnvironment repositoryEnvironment;
    private final ConcurrentHashMap<Integer, Transactions.TransactionFunction> completeTxFunctionByTxId = new ConcurrentHashMap();
    private ExecutionContext context;

    protected AbstractSessionCache(ExecutionContext context, WorkspaceCache sharedWorkspaceCache, RepositoryEnvironment repositoryEnvironment) {
        this.context = context;
        this.sharedWorkspaceCache = sharedWorkspaceCache;
        this.workspaceCache.set(sharedWorkspaceCache);
        ValueFactories factories = this.context.getValueFactories();
        this.nameFactory = factories.getNameFactory();
        this.pathFactory = factories.getPathFactory();
        this.rootPath = this.pathFactory.createRootPath();
        this.repositoryEnvironment = repositoryEnvironment;
        assert (this.repositoryEnvironment != null);
        this.checkForTransaction();
    }

    protected abstract Logger logger();

    @Override
    public void checkForTransaction() {
        try {
            Transactions transactions = this.repositoryEnvironment.getTransactions();
            Transaction txn = transactions.getTransactionManager().getTransaction();
            if (txn != null && txn.getStatus() == 0) {
                int txId;
                this.workspaceCache.set(this.repositoryEnvironment.getTransactionalWorkspaceCacheFactory().getTransactionalWorkspaceCache(this.sharedWorkspaceCache));
                Transactions.Transaction modeshapeTx = transactions.currentTransaction();
                if (modeshapeTx != null && !this.completeTxFunctionByTxId.containsKey(txId = System.identityHashCode(modeshapeTx))) {
                    Transactions.TransactionFunction completeFunction = new Transactions.TransactionFunction(){

                        @Override
                        public void execute() {
                            AbstractSessionCache.this.completeTransaction(txId);
                        }
                    };
                    if (this.completeTxFunctionByTxId.putIfAbsent(txId, completeFunction) == null) {
                        modeshapeTx.uponCompletion(completeFunction);
                    }
                }
            } else {
                this.completeTransaction(null);
            }
        }
        catch (SystemException e) {
            this.logger().error((Throwable)e, (I18nResource)JcrI18n.errorDeterminingCurrentTransactionAssumingNone, new Object[]{this.workspaceName(), e.getMessage()});
        }
        catch (RollbackException e) {
            this.logger().error((Throwable)e, (I18nResource)JcrI18n.errorDeterminingCurrentTransactionAssumingNone, new Object[]{this.workspaceName(), e.getMessage()});
        }
    }

    protected void completeTransaction(Integer txId) {
        this.workspaceCache.set(this.sharedWorkspaceCache);
        if (txId != null) {
            this.completeTxFunctionByTxId.remove(txId);
        }
    }

    @Override
    public final SessionCache unwrap() {
        return this;
    }

    protected final String workspaceName() {
        return this.workspaceCache().getWorkspaceName();
    }

    @Override
    public final ExecutionContext getContext() {
        return this.context;
    }

    @Override
    public final WorkspaceCache workspaceCache() {
        return this.workspaceCache.get();
    }

    final DocumentTranslator translator() {
        return this.workspaceCache().translator();
    }

    final ExecutionContext context() {
        return this.context;
    }

    final NameFactory nameFactory() {
        return this.nameFactory;
    }

    final PathFactory pathFactory() {
        return this.pathFactory;
    }

    final Path rootPath() {
        return this.rootPath;
    }

    RepositoryEnvironment sessionContext() {
        return this.repositoryEnvironment;
    }

    @Override
    public final void addContextData(String key, String value) {
        this.context = this.context.with(key, value);
    }

    @Override
    public NodeKey createNodeKey() {
        return this.getRootKey().withId(this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKeyWithIdentifier(String identifier) {
        return this.getRootKey().withId(identifier);
    }

    @Override
    public NodeKey createNodeKeyWithSource(String sourceName) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        return this.getRootKey().withSourceKeyAndId(sourceKey, this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKey(String sourceName, String identifier) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        if (identifier == null) {
            identifier = this.generateIdentifier();
        }
        return this.getRootKey().withSourceKeyAndId(sourceKey, identifier);
    }

    protected String generateIdentifier() {
        return UUID.randomUUID().toString();
    }

    @Override
    public NodeKey getRootKey() {
        return this.workspaceCache().getRootKey();
    }

    @Override
    public WorkspaceCache getWorkspace() {
        return this.workspaceCache();
    }

    @Override
    public CachedNode getNode(NodeKey key) {
        return this.workspaceCache().getNode(key);
    }

    @Override
    public CachedNode getNode(ChildReference reference) {
        return this.getNode(reference.getKey());
    }

    @Override
    public Set<NodeKey> getNodeKeysAtAndBelow(NodeKey nodeKey) {
        CachedNode node = this.getNode(nodeKey);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        result.add(nodeKey);
        for (ChildReference reference : node.getChildReferences(this)) {
            NodeKey childKey = reference.getKey();
            result.addAll(this.getNodeKeysAtAndBelow(childKey));
        }
        return result;
    }

    @Override
    public abstract SessionNode mutable(NodeKey var1);

    @Override
    public Iterator<NodeKey> getAllNodeKeys() {
        return this.getAllNodeKeysAtAndBelow(this.getRootKey());
    }

    @Override
    public Iterator<NodeKey> getAllNodeKeysAtAndBelow(NodeKey startingKey) {
        return new NodeCacheIterator(this, startingKey);
    }

    @Override
    public final void clear(CachedNode node) {
        this.doClear(node);
        WorkspaceCache wscache = this.workspaceCache.get();
        if (wscache != this.sharedWorkspaceCache) {
            assert (wscache instanceof TransactionalWorkspaceCache);
            wscache.clear();
        }
    }

    @Override
    public final void clear() {
        this.doClear();
        WorkspaceCache wscache = this.workspaceCache.get();
        if (wscache != this.sharedWorkspaceCache) {
            assert (wscache instanceof TransactionalWorkspaceCache);
            wscache.clear();
        }
    }

    protected abstract void doClear(CachedNode var1);

    protected abstract void doClear();

    protected abstract void addBinaryReference(NodeKey var1, BinaryKey ... var2);

    @Immutable
    protected static final class BasicSaveContext
    implements SessionCache.SaveContext {
        private final DateTime now;
        private final String userId;

        protected BasicSaveContext(ExecutionContext context) {
            this.now = context.getValueFactories().getDateFactory().create();
            this.userId = context.getSecurityContext().getUserName();
        }

        @Override
        public DateTime getTime() {
            return this.now;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }
    }
}

