/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.JChannel;
import org.jgroups.blocks.executor.ExecutorEvent;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.Executing;

public class ExecutionRunner
implements Runnable {
    protected JChannel ch;
    protected Executing _execProt;
    private final Map<Thread, Holder<Runnable>> _runnables = new ConcurrentHashMap<Thread, Holder<Runnable>>();
    protected static final Log _logger = LogFactory.getLog(ExecutionRunner.class);

    public ExecutionRunner(JChannel channel) {
        this.setChannel(channel);
    }

    public void setChannel(JChannel ch) {
        this.ch = ch;
        this._execProt = (Executing)ch.getProtocolStack().findProtocol((Class<?>)Executing.class);
        if (this._execProt == null) {
            throw new IllegalStateException("Channel configuration must include a executing protocol (subclass of " + Executing.class.getName() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            final ReentrantLock shutdownLock = new ReentrantLock();
            final AtomicBoolean canInterrupt = new AtomicBoolean(true);
            final AtomicBoolean shutdown = new AtomicBoolean();
            Thread executionThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    Object[] runnable = null;
                    while (!shutdown.get()) {
                        Object[] objectArray;
                        ExecutionRunner.this._runnables.put(currentThread, new Holder<Object>(null));
                        runnable = (Object[])ExecutionRunner.this.ch.down(new ExecutorEvent(1025, null));
                        if (runnable == null) break;
                        shutdownLock.lock();
                        try {
                            Thread.interrupted();
                            canInterrupt.set(false);
                        }
                        finally {
                            shutdownLock.unlock();
                        }
                        ExecutionRunner.this._runnables.put(currentThread, new Holder<Runnable>((Runnable)runnable));
                        Throwable throwable = null;
                        try {
                            runnable.run();
                        }
                        catch (Throwable t) {
                            _logger.error("Unexpected Runtime Error encountered in Runnable request", t);
                            throwable = t;
                        }
                        JChannel jChannel = ExecutionRunner.this.ch;
                        if (throwable != null) {
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = runnable;
                            objectArray = objectArray2;
                            objectArray2[1] = throwable;
                        } else {
                            objectArray = runnable;
                        }
                        jChannel.down(new ExecutorEvent(1026, objectArray));
                        shutdownLock.lock();
                        try {
                            canInterrupt.set(true);
                        }
                        finally {
                            shutdownLock.unlock();
                        }
                    }
                    ExecutionRunner.this._runnables.remove(currentThread);
                }
            };
            executionThread.setName(Thread.currentThread().getName() + "- Task Runner");
            executionThread.start();
            try {
                executionThread.join();
            }
            catch (InterruptedException e) {
                shutdownLock.lock();
                try {
                    if (canInterrupt.get()) {
                        executionThread.interrupt();
                    }
                    shutdown.set(true);
                }
                finally {
                    shutdownLock.unlock();
                }
                if (!_logger.isTraceEnabled()) break block7;
                _logger.trace("Shutting down Execution Runner");
            }
        }
    }

    public Map<Thread, Runnable> getCurrentRunningTasks() {
        HashMap<Thread, Runnable> map = new HashMap<Thread, Runnable>();
        for (Map.Entry<Thread, Holder<Runnable>> entry : this._runnables.entrySet()) {
            map.put(entry.getKey(), (Runnable)entry.getValue().value);
        }
        return map;
    }

    protected static class Holder<T> {
        protected T value;

        public Holder(T value) {
            this.value = value;
        }
    }
}

