/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.license.Clock;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProductException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseVersionException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.RealClock;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseTransaction;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseService
implements LicenseService {
    protected static final Logger log = LoggerFactory.getLogger(AbstractLicenseService.class);
    protected static final int MINIMUM_LICENSE_VERSION = 3;
    protected final Clock clock;
    protected final File licenseFile;
    protected final String product;
    protected final Set<String> allowedEditions = ImmutableSet.of((Object)LicenseVersion3.Edition.Trial.name(), (Object)LicenseVersion3.Edition.Enterprise.name());
    protected License license;
    protected LicenseCiCounter ciCounter;
    protected RepositoryService repositoryService;
    protected RepositoryMetadataService repositoryMetadataService;

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) throws IOException {
        this(licensePath, product, repositoryMetadataService, new RealClock());
    }

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService, Clock clock) {
        this.product = product;
        this.licenseFile = new File(licensePath);
        this.repositoryMetadataService = (RepositoryMetadataService)Preconditions.checkNotNull((Object)repositoryMetadataService);
        this.clock = clock;
    }

    @Override
    public void initialize(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
        this.reLoadCiCounter();
    }

    protected void logLicenseError(File licenseFile) {
        log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
        log.warn("*** Place a valid license in {} to continue using the product.", (Object)licenseFile.getAbsolutePath());
    }

    protected void logLicenseVersionError(License license, int minimumLicenseVersion) {
        log.error("*** Your license is version {}, but a minimum version of {} is required", (Object)license.getLicenseVersion(), (Object)minimumLicenseVersion);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    protected void reLoadCiCounter() {
        log.debug("Loading license CI counter using current license.");
        this.ciCounter = LicenseCiCounter.readFrom(this.license, this.repositoryService);
        log.debug("License CI counter loaded and contains {} allowed CIs.", (Object)this.ciCounter.allowedCiAmounts().size());
    }

    protected void logLicenseEditionError(License license) {
        log.error("*** Your license has edition {}, but only {} is allowed", (Object)license.getStringValue(LicenseProperty.EDITION), this.allowedEditions);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    @Override
    public LicenseCiCounter getCounter() {
        if (this.ciCounter == null) {
            throw new IllegalStateException("ciCounter is null. Did you forget to initialize the license server?");
        }
        return this.ciCounter;
    }

    @Override
    public boolean isLicenseExpired() {
        return this.license.isDateExpired(new LocalDate(this.clock.millis()));
    }

    @Override
    public Period getValidPeriod() {
        LocalDate localDateValue = this.license.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        LocalDate now = new LocalDate(this.clock.millis());
        if (now.isAfter((ReadablePartial)localDateValue)) {
            return Period.ZERO;
        }
        return new Period((ReadablePartial)now, (ReadablePartial)localDateValue, PeriodType.days());
    }

    @Override
    public void validate() throws LicenseViolationException {
        this.validateLicenseProperties(this.license);
        this.ciCounter.validate();
    }

    @Override
    public void validate(License license) throws LicenseViolationException {
        this.validateLicenseProperties(license);
        LicenseCiCounter tmpCiCounter = LicenseCiCounter.readFrom(license, this.repositoryService);
        tmpCiCounter.validate();
    }

    @Override
    public void reload() throws LicenseViolationException, LicenseParseException {
        this.license = this.readLicense(this.licenseFile);
        this.reLoadCiCounter();
        this.validate();
    }

    @Override
    public License getLicense() {
        return this.license;
    }

    @Override
    public LicenseTransaction startTransaction() {
        return new LicenseTransaction();
    }

    @Override
    public void rollbackTransaction(LicenseTransaction transaction) {
        for (Type type : transaction.getCiCountTypes()) {
            this.ciCounter.getAtomicCiCount(type).addAndGet(-transaction.getCiCount(type));
        }
    }

    protected void validateLicenseProperties(License license) throws LicenseViolationException {
        if (license.isDummyLicense()) {
            return;
        }
        String licenseProduct = license.getStringValue(LicenseProperty.PRODUCT);
        if (!this.product.equals(licenseProduct)) {
            throw new LicenseProductException(String.format("license is issued for %s, but used in %s", licenseProduct, this.product));
        }
        if (license.isDateExpired(new LocalDate(this.clock.millis()))) {
            throw new LicensePeriodExpiredException("the license has expired");
        }
        if (!license.isAtLeastVersion(3)) {
            throw new LicenseVersionException(String.format("for this version of %s, a license version %d or higher is required", license.getStringValue(LicenseProperty.PRODUCT), 3));
        }
        if (!this.isValidEdition(license)) {
            throw new LicenseEditionException(String.format("for this version of %s, the license must be one of %s", license.getStringValue(LicenseProperty.PRODUCT), this.allowedEditions));
        }
        String stringValue = license.getStringValue(LicenseProperty.REPOSITORY_ID);
        if (!Strings.isNullOrEmpty((String)stringValue)) {
            this.repositoryMetadataService.validateAndStoreRepositoryId(stringValue);
        }
    }

    protected boolean isValidEdition(License license) {
        return this.allowedEditions.contains(license.getStringValue(LicenseProperty.EDITION));
    }

    protected abstract License readLicense(File var1) throws LicenseParseException, LicenseViolationException;
}

