/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.config;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.rzo.yajsw.util.VFSUtils;

public class FilePropertiesConfiguration
extends PropertiesConfiguration {
    String _fileName;
    File _url;
    FileSystem _fileSystem;
    String _encoding;

    public FilePropertiesConfiguration(File file) throws Exception {
        this._fileName = file.getAbsolutePath();
        this.load();
    }

    public FilePropertiesConfiguration() {
    }

    public String getPath() {
        return this._fileName;
    }

    public String getFileName() {
        try {
            return VFSUtils.resolveFile(".", this._fileName).getName().getBaseName();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return this._fileName;
        }
    }

    public String getURL() throws Exception {
        return this._fileName;
    }

    public FileSystem getFileSystem() {
        return this._fileSystem;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        Reader reader = null;
        try {
            FileObject f = VFSUtils.resolveFile(".", this._fileName);
            InputStream in = f.getContent().getInputStream();
            reader = new InputStreamReader(in);
            this.read(reader);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void reload() throws Exception {
        super.clear();
        this.load();
    }

    public FilePropertiesConfiguration interpolatedFileConfiguration() {
        FilePropertiesConfiguration result = new FilePropertiesConfiguration();
        result.copy(this.interpolatedConfiguration());
        result.setFileName(this._fileName);
        return result;
    }

    public void save(File cn) throws Exception {
        FileWriter writer = new FileWriter(cn);
        this.write(writer);
        ((Writer)writer).close();
    }
}

