/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.resteasy;

import com.xebialabs.deployit.security.Permissions;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Provider
@Component
@ServerInterceptor
public class UsernameInjectorPrePostProcessor
implements PreProcessInterceptor,
PostProcessInterceptor {
    public static final String MDC_KEY_USERNAME = "username";

    public void postProcess(ServerResponse response) {
        UsernameInjectorPrePostProcessor.cleanup();
    }

    public static void cleanup() {
        MDC.remove((String)MDC_KEY_USERNAME);
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethodInvoker method) throws Failure, WebApplicationException {
        Authentication authentication = Permissions.getAuthentication();
        if (authentication != null) {
            MDC.put((String)MDC_KEY_USERNAME, (String)authentication.getName());
        }
        return null;
    }
}

