/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.test.statementexecutorconsumer;

import fitnesse.slim.SlimSymbol;
import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class TableTableIncFirstCol
implements StatementExecutorConsumer {
    private StatementExecutorInterface context;

    @Override
    public void setStatementExecutor(StatementExecutorInterface statementExecutor) {
        this.context = statementExecutor;
        this.context.assign("SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS", "tableTable.*\\.doTable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> doTable(List<List<?>> table) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        try {
            for (List<?> line : table) {
                ArrayList<String> retLine = new ArrayList<String>();
                ret.add(retLine);
                retLine.add("no change");
                String oldValue = this.replaceSymbolsInString(line.get(0).toString());
                int newValue = Integer.parseInt(oldValue) + 1;
                this.assignSymbolIfApplicable(line.get(1).toString(), newValue);
                retLine.add("pass:" + newValue);
            }
        }
        finally {
            this.context.assign("SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS", null);
        }
        return ret;
    }

    private String replaceSymbolsInString(String arg) {
        Matcher symbolMatcher;
        int startingPosition = 0;
        while (!"".equals(arg) && null != arg && (symbolMatcher = SlimSymbol.SYMBOL_PATTERN.matcher(arg)).find(startingPosition)) {
            String symbolName = symbolMatcher.group(1);
            arg = this.replaceSymbolInArg(symbolMatcher, arg, symbolName);
            startingPosition = symbolMatcher.start(1);
        }
        return arg;
    }

    private String replaceSymbolInArg(Matcher symbolMatcher, String arg, String symbolName) {
        String replacement = "null";
        Object value = this.context.getSymbol(symbolName);
        if (value != null) {
            replacement = value.toString();
        }
        arg = arg.substring(0, symbolMatcher.start()) + replacement + arg.substring(symbolMatcher.end());
        return arg;
    }

    private void assignSymbolIfApplicable(String text, int value) {
        String symbol = SlimSymbol.isSymbolAssignment(text);
        if (symbol != null) {
            this.context.assign(symbol, value);
        }
    }
}

