/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;

public class StackTraceEnricher {
    private Map<String, ClassMetaInformation> elementInformation = new HashMap<String, ClassMetaInformation>();

    public void printStackTrace(Throwable throwable) {
        try {
            this.printStackTrace(throwable, System.err);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printStackTrace(Throwable throwable, OutputStream stream) throws IOException {
        stream.write(this.getStackTraceAsString(throwable).getBytes("UTF-8"));
        stream.flush();
    }

    public void printStackTrace(Throwable throwable, Writer writer) throws IOException {
        writer.write(this.getStackTraceAsString(throwable));
        writer.flush();
    }

    public String getStackTraceAsString(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable t = throwable;
        if (throwable.getStackTrace() == null || throwable.getStackTrace().length == 0) {
            t = throwable.fillInStackTrace();
        }
        for (StackTraceElement ste : t.getStackTrace()) {
            sb.append("\n\tat ").append(ste.toString());
            ClassMetaInformation cmi = this.getMetaInformation(ste);
            sb.append(" [");
            sb.append(cmi.getLocation());
            if (!cmi.getVersion().equals("n/a")) {
                sb.append(":").append(cmi.getVersion());
            }
            sb.append("]");
        }
        if (throwable.getCause() != null) {
            Throwable cause = throwable.getCause();
            sb.append("\nCaused by: ").append(cause.getClass().getName()).append(": ").append(cause.getMessage());
            sb.append(this.getStackTraceAsString(cause));
        }
        return sb.toString();
    }

    public String getVersion(Class<?> clazz) {
        return this.getMetaInformation(clazz).getVersion();
    }

    public String getVersion(StackTraceElement element) {
        return this.getMetaInformation(element).getVersion();
    }

    public String getLocation(Class<?> clazz) {
        return this.getMetaInformation(clazz).getLocation();
    }

    public String getLocation(StackTraceElement element) {
        return this.getMetaInformation(element).getLocation();
    }

    private ClassMetaInformation getMetaInformation(Class<?> clazz) {
        ClassMetaInformation information;
        if (this.elementInformation.containsKey(clazz.getName())) {
            information = this.elementInformation.get(clazz.getName());
        } else {
            information = new ClassMetaInformation(clazz);
            this.elementInformation.put(clazz.getName(), information);
        }
        return information;
    }

    private ClassMetaInformation getMetaInformation(StackTraceElement element) {
        ClassMetaInformation information;
        if (this.elementInformation.containsKey(element.getClassName())) {
            information = this.elementInformation.get(element.getClassName());
        } else {
            information = new ClassMetaInformation(element);
            this.elementInformation.put(element.getClassName(), information);
        }
        return information;
    }

    private static class ClassMetaInformation {
        private static final String UNKNOWN = "n/a";
        private static final String[] PACKAGE_PREFIXES_RTJAR = new String[]{"java.", "javax.", "sun.", "sunw.", "javafx.", "com.sun."};
        private String version = "n/a";
        private String location = "n/a";
        private String className = "n/a";
        private String file = "n/a";

        public ClassMetaInformation(Class<?> clazz) {
            this.analyse(clazz.getName());
        }

        public ClassMetaInformation(StackTraceElement ste) {
            this.file = ste.getFileName();
            this.analyse(ste.getClassName());
        }

        private void analyse(String className) {
            try {
                Class<?> elementClass = ClassMetaInformation.loadClass(className, ClassLoader.getSystemClassLoader());
                this.analyse(elementClass);
            }
            catch (ClassNotFoundException cnfe) {
                this.className = className;
            }
        }

        private void analyse(Class clazz) {
            this.className = clazz.getName();
            this.version = ClassMetaInformation.getVersion(clazz);
            this.location = ClassMetaInformation.getLocation(clazz);
        }

        public String getVersion() {
            return this.version;
        }

        public String getLocation() {
            return this.location;
        }

        private static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
            if (className == null || className.isEmpty()) {
                throw new ClassNotFoundException("Unable to load a class with an empty or null name.");
            }
            Class<?> resolvedClass = null;
            if (classLoader != null) {
                try {
                    resolvedClass = classLoader.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (resolvedClass == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                resolvedClass = contextClassLoader != null ? contextClassLoader.loadClass(className) : StackTraceEnricher.class.getClassLoader().loadClass(className);
            }
            return resolvedClass;
        }

        private static String getLocation(Class<?> clazz) {
            String location;
            block5: {
                location = UNKNOWN;
                if (clazz != null) {
                    try {
                        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                        if (codeSource != null) {
                            String fullLocation = codeSource.getLocation().toString();
                            location = ClassMetaInformation.isDirectory(fullLocation) ? fullLocation : ClassMetaInformation.removeParentDirectories(fullLocation);
                            break block5;
                        }
                        for (String rtPackage : PACKAGE_PREFIXES_RTJAR) {
                            if (!clazz.getName().startsWith(rtPackage)) continue;
                            location = "rt.jar";
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return location;
        }

        private static String getVersion(Class<?> clazz) {
            String version = UNKNOWN;
            if (clazz != null) {
                try {
                    Package pack = clazz.getPackage();
                    if (pack != null) {
                        if (pack.getImplementationVersion() != null) {
                            version = pack.getImplementationVersion();
                        } else if (pack.getSpecificationVersion() != null) {
                            version = pack.getSpecificationVersion();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return version;
        }

        private static String removeParentDirectories(String path) {
            String parsedPath = path;
            if (path.contains("/")) {
                parsedPath = ClassMetaInformation.removeParentDirectories(path, "/");
            } else if (path.contains("\\")) {
                parsedPath = ClassMetaInformation.removeParentDirectories(path, "\\");
            }
            return parsedPath;
        }

        private static String removeParentDirectories(String path, String separator) {
            String parsedPath = path;
            if (path.contains(separator) && !path.endsWith(separator) || path.indexOf(separator) < path.lastIndexOf(separator)) {
                parsedPath = parsedPath.substring(parsedPath.indexOf(separator) + 1);
                parsedPath = ClassMetaInformation.removeParentDirectories(parsedPath, separator);
            }
            return parsedPath;
        }

        private static boolean isDirectory(String path) {
            return path != null && (path.endsWith("/") || path.endsWith("\\"));
        }
    }
}

