/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ConverterSupport;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimService;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.slim.fixtureInteraction.InteractionAwareFixture;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class MethodExecutor {
    private static final Method AROUND_METHOD;

    public abstract MethodExecutionResult execute(String var1, String var2, Object[] var3) throws Throwable;

    protected Method findMatchingMethod(String methodName, Class<?> k, int nArgs) {
        Method[] methods;
        for (Method method : methods = k.getMethods()) {
            boolean hasMatchingArguments;
            boolean hasMatchingName = method.getName().equals(methodName);
            boolean bl = hasMatchingArguments = method.getParameterTypes().length == nArgs;
            if (!hasMatchingName || !hasMatchingArguments) continue;
            return method;
        }
        return null;
    }

    protected MethodExecutionResult invokeMethod(Object instance, Method method, Object[] args) throws Throwable {
        Object[] convertedArgs = this.convertArgs(method, args);
        Object retval = this.callMethod(instance, method, convertedArgs);
        Class<?> retType = method.getReturnType();
        return new MethodExecutionResult(retval, retType);
    }

    protected Object[] convertArgs(Method method, Object[] args) {
        Type[] argumentParameterTypes = method.getGenericParameterTypes();
        return ConverterSupport.convertArgs(args, argumentParameterTypes);
    }

    protected Object callMethod(Object instance, Method method, Object[] convertedArgs) throws Throwable {
        FixtureInteraction interaction = SlimService.getInteraction();
        try {
            Object result;
            if (instance instanceof InteractionAwareFixture) {
                Object[] args = new Object[]{interaction, method, convertedArgs};
                result = interaction.methodInvoke(AROUND_METHOD, instance, args);
            } else {
                result = interaction.methodInvoke(method, instance, convertedArgs);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e.getTargetException();
        }
    }

    protected MethodExecutionResult findAndInvoke(String methodName, Object[] args, Object instance) throws Throwable {
        Method method = this.findMatchingMethod(methodName, instance.getClass(), args.length);
        if (method != null) {
            return this.invokeMethod(instance, method, args);
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }

    static {
        try {
            AROUND_METHOD = InteractionAwareFixture.class.getMethod("aroundSlimInvoke", FixtureInteraction.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

