/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testrunner.WikiTestPageUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VersionResponder
implements SecureResponder {
    private String version;
    private String resource;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) {
        WikiPagePath path;
        this.resource = request.getResource();
        this.version = request.getInput("version");
        if (this.version == null) {
            return new ErrorResponder("No version specified.").makeResponse(context, request);
        }
        PageCrawler pageCrawler = context.getRootPage(request.getMap()).getPageCrawler();
        WikiPage page = pageCrawler.getPage(path = PathParser.parse(this.resource));
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        String fullPathName = PathParser.render(page.getPageCrawler().getFullPath());
        HtmlPage html = this.makeHtml(fullPathName, page, context);
        SimpleResponse response = new SimpleResponse();
        response.setContent(html.html());
        return response;
    }

    private HtmlPage makeHtml(String name, WikiPage page, FitNesseContext context) {
        WikiPage pageVersion = page.getVersion(this.version);
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("Version " + this.version + ": " + name);
        html.setPageTitle(new PageTitle("Version " + this.version, PathParser.parse(this.resource), pageVersion.getData().getAttribute("Suites")));
        html.setNavTemplate("versionNav.vm");
        html.put("rollbackVersion", this.version);
        html.put("localPath", name);
        ArrayList<VersionInfo> versions = new ArrayList<VersionInfo>(page.getVersions());
        Collections.sort(versions);
        Collections.reverse(versions);
        String nextVersion = this.selectNextVersion(versions, this.version);
        html.put("nextVersion", nextVersion);
        String previousVersion = this.selectPreviousVersion(versions, this.version);
        html.put("previousVersion", previousVersion);
        html.setMainTemplate("wikiPage");
        html.put("content", new VersionRenderer(pageVersion));
        return html;
    }

    private String selectPreviousVersion(List<VersionInfo> versions, String current) {
        int i = 0;
        for (i = 0; i < versions.size() && !versions.get(i).getName().equals(current); ++i) {
        }
        if (i < 0 || i > versions.size() - 2) {
            return null;
        }
        return versions.get(i + 1).getName();
    }

    private String selectNextVersion(List<VersionInfo> versions, String current) {
        int i;
        for (i = 0; i < versions.size() && !versions.get(i).getName().equals(current); ++i) {
        }
        if (i < 1 || i > versions.size()) {
            return null;
        }
        return versions.get(i - 1).getName();
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    public class VersionRenderer {
        private WikiPage page;

        public VersionRenderer(WikiPage page) {
            this.page = page;
        }

        public String render() {
            if (WikiPageUtil.isTestPage(this.page)) {
                WikiTestPage testPage = new WikiTestPage(this.page);
                return WikiTestPageUtil.makePageHtml(testPage);
            }
            return WikiPageUtil.makePageHtml(this.page);
        }
    }
}

