/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.ConfigurationParameter;
import fitnesse.ContextConfigurator;
import fitnesse.FitNesseContext;
import fitnesse.junit.JUnitRunNotifierResultsListener;
import fitnesse.junit.JavaFormatter;
import fitnesse.plugins.PluginException;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.PagesByTestSystem;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testsystems.ConsoleExecutionLogListener;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class FitNesseRunner
extends ParentRunner<WikiPage> {
    private Class<?> suiteClass;
    private String suiteName;
    private String outputDir;
    private String suiteFilter;
    private boolean suiteFilterAndStrategy;
    private String excludeSuiteFilter;
    private boolean debugMode;
    private boolean preventSystemExit;
    private FitNesseContext context;
    private List<WikiPage> children;

    public FitNesseRunner(Class<?> suiteClass) throws InitializationError {
        super(suiteClass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.suiteClass = this.getTestClass().getJavaClass();
        try {
            this.suiteName = this.getSuiteName(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.outputDir = this.getOutputDir(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.suiteFilter = this.getSuiteFilter(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.suiteFilterAndStrategy = this.getSuiteFilterAndStrategy(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.excludeSuiteFilter = this.getExcludeSuiteFilter(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.debugMode = this.useDebugMode(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.preventSystemExit = this.shouldPreventSystemExit(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.context = this.createContext(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
    }

    protected FitNesseContext createContext(Class<?> suiteClass) throws Exception {
        String rootPath = this.getFitNesseDir(suiteClass);
        String fitNesseRoot = this.getFitNesseRoot(suiteClass);
        int port = this.getPort(suiteClass);
        File configFile = this.getConfigFile(rootPath, suiteClass);
        return FitNesseRunner.initContext(configFile, rootPath, fitNesseRoot, port);
    }

    protected String getSuiteName(Class<?> klass) throws InitializationError {
        Suite suiteAnnotation = klass.getAnnotation(Suite.class);
        if (suiteAnnotation == null) {
            throw new InitializationError("There must be a @Suite annotation");
        }
        if (!"".equals(suiteAnnotation.value())) {
            return suiteAnnotation.value();
        }
        if (!"".equals(suiteAnnotation.systemProperty())) {
            return System.getProperty(suiteAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @Suite you have to specify either 'value' or 'systemProperty'");
    }

    protected String getOutputDir(Class<?> klass) throws InitializationError {
        OutputDir outputDirAnnotation = klass.getAnnotation(OutputDir.class);
        if (outputDirAnnotation == null) {
            throw new InitializationError("There must be a @OutputDir annotation");
        }
        if (!"".equals(outputDirAnnotation.value())) {
            return outputDirAnnotation.value();
        }
        if (!"".equals(outputDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(outputDirAnnotation.systemProperty());
            File outputDir = new File(baseDir, outputDirAnnotation.pathExtension());
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @OutputDir you have to specify either 'value' or 'systemProperty'");
    }

    protected String getSuiteFilter(Class<?> klass) throws Exception {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return null;
        }
        if (!"".equals(suiteFilterAnnotation.value())) {
            return suiteFilterAnnotation.value();
        }
        if (!"".equals(suiteFilterAnnotation.systemProperty())) {
            return System.getProperty(suiteFilterAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @SuiteFilter you have to specify either 'value' or 'systemProperty'");
    }

    protected boolean getSuiteFilterAndStrategy(Class<?> klass) throws Exception {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return false;
        }
        return suiteFilterAnnotation.andStrategy();
    }

    protected String getExcludeSuiteFilter(Class<?> klass) throws Exception {
        ExcludeSuiteFilter excludeSuiteFilterAnnotation = klass.getAnnotation(ExcludeSuiteFilter.class);
        if (excludeSuiteFilterAnnotation == null) {
            return null;
        }
        return excludeSuiteFilterAnnotation.value();
    }

    protected boolean useDebugMode(Class<?> klass) throws Exception {
        DebugMode debugModeAnnotation = klass.getAnnotation(DebugMode.class);
        if (null == debugModeAnnotation) {
            return true;
        }
        return debugModeAnnotation.value();
    }

    protected boolean shouldPreventSystemExit(Class<?> klass) throws Exception {
        PreventSystemExit preventSystemExitAnnotation = klass.getAnnotation(PreventSystemExit.class);
        if (null == preventSystemExitAnnotation) {
            return true;
        }
        return preventSystemExitAnnotation.value();
    }

    protected String getFitNesseDir(Class<?> klass) throws InitializationError {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        if (fitnesseDirAnnotation == null) {
            throw new InitializationError("There must be a @FitnesseDir annotation");
        }
        if (!"".equals(fitnesseDirAnnotation.value())) {
            return fitnesseDirAnnotation.value();
        }
        if (!"".equals(fitnesseDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(fitnesseDirAnnotation.systemProperty());
            File outputDir = new File(baseDir);
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @FitnesseDir you have to specify either 'value' or 'systemProperty'");
    }

    protected String getFitNesseRoot(Class<?> klass) {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        return fitnesseDirAnnotation.fitNesseRoot();
    }

    public int getPort(Class<?> klass) throws Exception {
        Port portAnnotation = klass.getAnnotation(Port.class);
        if (null == portAnnotation) {
            return 0;
        }
        int lport = portAnnotation.value();
        if (!"".equals(portAnnotation.systemProperty())) {
            lport = Integer.getInteger(portAnnotation.systemProperty(), lport);
        }
        return lport;
    }

    protected File getConfigFile(String rootPath, Class<?> klass) throws Exception {
        ConfigFile configFileAnnotation = klass.getAnnotation(ConfigFile.class);
        if (null == configFileAnnotation) {
            return new File(rootPath, "plugins.properties");
        }
        return new File(configFileAnnotation.value());
    }

    protected Description describeChild(WikiPage child) {
        return Description.createTestDescription(this.suiteClass, (String)child.getPageCrawler().getFullPath().toString());
    }

    protected List<WikiPage> getChildren() {
        if (this.children == null) {
            this.children = this.initChildren();
        }
        return this.children;
    }

    public void run(RunNotifier notifier) {
        if (this.isFilteredForChildTest()) {
            super.run(notifier);
        } else {
            this.runPages(this.children, notifier);
        }
    }

    private boolean isFilteredForChildTest() {
        return this.getDescription().getChildren().size() < this.getChildren().size();
    }

    protected void runChild(WikiPage page, RunNotifier notifier) {
        this.runPages(this.listOf(page), notifier);
    }

    protected void runPages(List<WikiPage> pages, RunNotifier notifier) {
        MultipleTestsRunner testRunner = this.createTestRunner(pages);
        this.addTestSystemListeners(notifier, testRunner, this.suiteClass);
        this.addExecutionLogListener(notifier, testRunner, this.suiteClass);
        System.setProperty("prevent.system.exit", String.valueOf(this.preventSystemExit));
        try {
            this.executeTests(testRunner);
        }
        catch (AssertionError e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(this.suiteClass), (Throwable)e));
        }
    }

    protected void addTestSystemListeners(RunNotifier notifier, MultipleTestsRunner testRunner, Class<?> suiteClass) {
        testRunner.addTestSystemListener(new JUnitRunNotifierResultsListener(notifier, suiteClass));
    }

    protected void addExecutionLogListener(RunNotifier notifier, MultipleTestsRunner testRunner, Class<?> suiteClass) {
        testRunner.addExecutionLogListener(new ConsoleExecutionLogListener());
    }

    protected List<WikiPage> initChildren() {
        WikiPage suiteRoot = this.getSuiteRootPage();
        if (suiteRoot == null) {
            throw new IllegalArgumentException("No page " + this.suiteName);
        }
        List<WikiPage> children = suiteRoot.getData().hasAttribute("Suite") ? new SuiteContentsFinder(suiteRoot, this.getSuiteFilter(), this.context.getRootPage()).getAllPagesToRunForThisSuite() : Collections.singletonList(suiteRoot);
        return children;
    }

    private fitnesse.testrunner.SuiteFilter getSuiteFilter() {
        return new fitnesse.testrunner.SuiteFilter(this.getOrSuiteFilter(), this.excludeSuiteFilter, this.getAndSuiteFilter(), null);
    }

    private String getOrSuiteFilter() {
        return this.suiteFilterAndStrategy ? null : this.suiteFilter;
    }

    private String getAndSuiteFilter() {
        return this.suiteFilterAndStrategy ? this.suiteFilter : null;
    }

    static FitNesseContext initContext(File configFile, String rootPath, String fitNesseRoot, int port) throws IOException, PluginException {
        ContextConfigurator contextConfigurator = ContextConfigurator.systemDefaults().updatedWith(System.getProperties()).updatedWith(ConfigurationParameter.loadProperties(configFile)).updatedWith(ConfigurationParameter.makeProperties(new Object[]{ConfigurationParameter.PORT, port, ConfigurationParameter.ROOT_PATH, rootPath, ConfigurationParameter.ROOT_DIRECTORY, fitNesseRoot, ConfigurationParameter.OMITTING_UPDATES, true}));
        return contextConfigurator.makeFitNesseContext();
    }

    private WikiPage getSuiteRootPage() {
        WikiPagePath path = PathParser.parse(this.suiteName);
        PageCrawler crawler = this.context.getRootPage().getPageCrawler();
        return crawler.getPage(path);
    }

    private MultipleTestsRunner createTestRunner(List<WikiPage> pages) {
        PagesByTestSystem pagesByTestSystem = new PagesByTestSystem(pages, this.context.getRootPage());
        MultipleTestsRunner runner = new MultipleTestsRunner(pagesByTestSystem, this.context.testSystemFactory);
        runner.setRunInProcess(this.debugMode);
        return runner;
    }

    private void executeTests(MultipleTestsRunner testRunner) throws IOException, InterruptedException {
        JavaFormatter testFormatter = new JavaFormatter(this.suiteName);
        testFormatter.setResultsRepository(new JavaFormatter.FolderResultsRepository(this.outputDir));
        testRunner.addTestSystemListener(testFormatter);
        testRunner.executeTestPages();
        TestSummary summary = testFormatter.getTotalSummary();
        Assert.assertTrue((String)this.msgAtLeastOneTest(this.suiteName, summary), (summary.getRight() > 0 || summary.getWrong() > 0 || summary.getExceptions() > 0 ? 1 : 0) != 0);
    }

    private String msgAtLeastOneTest(String pageName, TestSummary summary) {
        return MessageFormat.format("at least one test executed in {0}\n{1}", pageName, summary.toString());
    }

    private List<WikiPage> listOf(WikiPage page) {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>(1);
        list.add(page);
        return list;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ConfigFile {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Deprecated
    public static @interface Port {
        public int value() default 0;

        public String systemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OutputDir {
        public String value() default "";

        public String systemProperty() default "";

        public String pathExtension() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FitnesseDir {
        public String value() default "";

        public String systemProperty() default "";

        public String fitNesseRoot() default "FitNesseRoot";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludeSuiteFilter {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteFilter {
        public String value() default "";

        public String systemProperty() default "";

        public boolean andStrategy() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PreventSystemExit {
        public boolean value() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DebugMode {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Suite {
        public String value() default "";

        public String systemProperty() default "";
    }
}

