/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlt.plugin.api.testrun.Event;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.service.EventBulkProcessor;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RenameEventPropertiesUpgrade
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(RenameEventPropertiesUpgrade.class);
    private final EventRepository eventRepository;
    private final int batchSize;

    @Autowired
    public RenameEventPropertiesUpgrade(EventRepository eventRepository, @Qualifier(value="xlt.upgrader.elasticsearch-batch-size") int batchSize) {
        this.eventRepository = eventRepository;
        this.batchSize = batchSize;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#3");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        this.eventRepository.refreshIndex();
        try {
            Map properties = Event.props((Object[])new Object[]{"type", "long"});
            this.eventRepository.updateMapping("importStarted", "@createdAt", properties);
            properties = Event.props((Object[])new Object[]{"type", "long"});
            this.eventRepository.updateMapping("importStarted", "@createdAt", properties);
            properties = Event.props((Object[])new Object[]{"type", "string", "index", "not_analyzed", "include_in_all", false});
            this.eventRepository.updateMapping("importStarted", "@testSpecification", properties);
            properties = Event.props((Object[])new Object[]{"type", "string", "index", "not_analyzed", "include_in_all", false});
            this.eventRepository.updateMapping("importStarted", "@type", properties);
            properties = Event.props((Object[])new Object[]{"type", "string", "index", "not_analyzed", "include_in_all", true});
            this.eventRepository.updateMapping("functionalResult", "@tags", properties);
            properties = Event.props((Object[])new Object[]{"type", "string", "index", "analyzed", "include_in_all", true});
            this.eventRepository.updateMapping("functionalResult", "@firstError", properties);
            this.eventRepository.bulkUpdate("", this.batchSize, new RenameEventPropertiesProcessor());
        }
        catch (Exception e) {
            throw new UpgradeException("Unable to perform upgrade", e);
        }
        this.eventRepository.refreshIndex();
        return true;
    }

    class RenameEventPropertiesProcessor
    implements EventBulkProcessor {
        RenameEventPropertiesProcessor() {
        }

        @Override
        public void process(List<Event> events) {
            LOG.info("RenameEventPropertiesProcessor, Processing {} events.", (Object)events.size());
            for (Event event : events) {
                LOG.debug("Event before processing: {}", (Object)event);
                this.replaceKey(event, "runId", "@runId");
                this.replaceKey(event, "timestamp", "@createdAt");
                this.replaceKey(event, "tags", "@tags");
                this.replaceKey(event, "lastModified", "@testedAt");
                this.replaceKey(event, "type", "@type");
                this.replaceKey(event, "testSpecification", "@testSpecification");
                this.replaceKey(event, "result", "@result");
                this.replaceKey(event, "duration", "@duration");
                this.replaceKey(event, "firstError", "@firstError");
                LOG.debug("Event after processing (not saved!): {}", (Object)event);
            }
            for (Event e : events) {
                LOG.debug("Persisting event: {}", (Object)e);
                RenameEventPropertiesUpgrade.this.eventRepository.updateAndPersist(e);
            }
        }

        public void replaceKey(Event event, String oldKey, String newKey) {
            Object value = event.get(oldKey);
            if (value != null) {
                event.update(newKey, value);
                event.remove(oldKey);
            }
        }
    }
}

