/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.api.v1.dto.TestSpecificationRequest;
import com.xebialabs.xltest.api.v1.dto.TestSpecificationResponse;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.PassiveTestSpecification;
import com.xebialabs.xltest.domain.QualificationResult;
import com.xebialabs.xltest.repository.ProjectRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.serialize.TestSpecificationTreeBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TestSpecificationService {
    public static final String MESSAGE = "message";
    public static final String RESULT = "result";
    private static final String TIME = "time";
    private ProjectRepository projectRepository;
    private TestSpecificationRepository testSpecificationRepository;
    private TestSpecificationTreeBuilder testSpecificationTreeBuilder;

    @Autowired
    public TestSpecificationService(ProjectRepository projectRepository, TestSpecificationRepository testSpecificationRepository, TestSpecificationTreeBuilder testSpecificationTreeBuilder) {
        this.projectRepository = projectRepository;
        this.testSpecificationRepository = testSpecificationRepository;
        this.testSpecificationTreeBuilder = testSpecificationTreeBuilder;
    }

    public BaseTestSpecification createPassiveTestSpecification(String projectId, TestSpecificationRequest testSpecification) {
        this.validateProject(projectId);
        String id = UUID.randomUUID().toString();
        PassiveTestSpecification instance = PassiveTestSpecification.newTestSpecification(Synthetic.createSpecificationForProjectId(projectId, id));
        instance.setTitle(testSpecification.getTitle());
        instance.setQualificationType(testSpecification.getQualificationType());
        instance.setTestToolName(testSpecification.getTestToolName());
        return this.projectRepository.createSpecificationForProject(projectId, (BaseTestSpecification)instance);
    }

    public BaseTestSpecification updateTestSpecification(String projectId, String testSpecificationId, TestSpecificationRequest request, String eTag) {
        this.validateProject(projectId);
        this.validateTestSpecId(testSpecificationId);
        BaseTestSpecification testSpecification = this.testSpecificationRepository.get(testSpecificationId);
        if (eTag != null && !testSpecification.get$token().equals(eTag)) {
            throw new ItemConflictException("Test specification with id '%s' has been updated since you read it. Please reload the test specification.", new Object[]{testSpecificationId});
        }
        testSpecification.setQualificationType(request.getQualificationType());
        testSpecification.setTitle(request.getTitle());
        ((PassiveTestSpecification)testSpecification).setTestToolName(request.getTestToolName());
        this.projectRepository.updateSpecificationOnly(testSpecification);
        return this.testSpecificationRepository.get(testSpecificationId);
    }

    public BaseTestSpecification getTestSpecification(String projectId, String testSpecId) {
        BaseTestSpecification testSpec;
        this.validateProject(projectId);
        this.validateTestSpecId(testSpecId);
        try {
            testSpec = this.testSpecificationRepository.getSpecificationForProject(projectId, testSpecId);
        }
        catch (NotFoundException ex) {
            throw new NotFoundException(String.format("TestSpecification %s not found", testSpecId), new Object[0]);
        }
        if (!PassiveTestSpecification.class.isAssignableFrom(((Object)((Object)testSpec)).getClass())) {
            throw new NotFoundException(String.format("TestSpecification %s not found", testSpecId), new Object[0]);
        }
        return testSpec;
    }

    public void deleteTestSpecification(String projectId, String testSpecificationId, boolean force, String eTag) {
        BaseTestSpecification testSpecification;
        this.validateProject(projectId);
        this.validateTestSpecId(testSpecificationId);
        try {
            testSpecification = this.testSpecificationRepository.getById(testSpecificationId);
        }
        catch (NotFoundException ex) {
            return;
        }
        if (eTag != null && !testSpecification.get$token().equals(eTag)) {
            throw new ItemConflictException("Test specification with id '%s' has been updated since you read it. Please reload the test specification.", new Object[]{testSpecificationId});
        }
        this.testSpecificationRepository.deleteTestSpecification(projectId, testSpecificationId, force);
    }

    public List<TestSpecificationResponse> getTestSpecifications(String projectId, String title) throws JSONException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)title)) {
            query.put("title", title);
        }
        return this.testSpecificationTreeBuilder.treeForPassiveTestSpecification(projectId, query);
    }

    public Response getQualificationForTestSpec(String testSpecification) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BaseTestSpecification testSpec = this.testSpecificationRepository.get(testSpecification);
        Optional<QualificationResult> qualificationResult = this.testSpecificationRepository.getLatestQualificationResult(testSpec);
        if (!qualificationResult.isPresent() && !testSpec.hasQualificationType()) {
            return Response.noContent().build();
        }
        if (!qualificationResult.isPresent()) {
            result.put(RESULT, false);
            result.put(MESSAGE, "No results available for this test specification");
            result.put("error_code", "no.qualification.results");
            return Response.status((int)200).entity(result).build();
        }
        switch (((QualificationResult)((Object)qualificationResult.get())).getResult()) {
            case PASSED: {
                result.put(RESULT, true);
                result.put(MESSAGE, ((QualificationResult)((Object)qualificationResult.get())).getLastFailureReason());
                result.put(TIME, ((QualificationResult)((Object)qualificationResult.get())).getTime().toString());
                return Response.ok(result).build();
            }
            case FAILED: {
                result.put(RESULT, false);
                result.put(MESSAGE, ((QualificationResult)((Object)qualificationResult.get())).getLastFailureReason());
                result.put(TIME, ((QualificationResult)((Object)qualificationResult.get())).getTime().toString());
                return Response.ok(result).build();
            }
        }
        throw new RuntimeException("Forgot to implement case: " + (Object)((Object)((QualificationResult)((Object)qualificationResult.get())).getResult()));
    }

    private void validateTestSpecId(String id) {
        String regex = "[a-zA-Z0-9_-]+";
        if (!id.matches(regex)) {
            throw new IllegalArgumentException(String.format("Test specification ID: '%s' is invalid and must be in the form of '%s'", id, regex));
        }
    }

    private void validateProject(String projectId) {
        this.projectRepository.validateProjectExists(projectId);
    }

    public BaseTestSpecification getSpecificationForProject(String projectId, String testSpecificationId) {
        this.validateProject(projectId);
        this.validateTestSpecId(testSpecificationId);
        BaseTestSpecification testSpec = this.testSpecificationRepository.getSpecificationForProject(projectId, testSpecificationId);
        if (!PassiveTestSpecification.class.isAssignableFrom(((Object)((Object)testSpec)).getClass())) {
            throw new NotFoundException(String.format("Test specification %s not found", testSpecificationId), new Object[0]);
        }
        return testSpec;
    }
}

