/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.service;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.xlt.plugin.api.repository.QualificationsRepository;
import com.xebialabs.xlt.plugin.api.testrun.TestRun;
import com.xebialabs.xlt.plugin.api.testrun.TestRunsRepository;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestSpecificationSet;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public class ReportService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportService.class);
    private final TestRunsRepository testRunsRepository;
    private final AutowireCapableBeanFactory beanFactory;
    private final QualificationsRepository qualificationsRepository;

    public ReportService(TestRunsRepository testRunsRepository, AutowireCapableBeanFactory beanFactory, QualificationsRepository qualificationsRepository) {
        this.testRunsRepository = testRunsRepository;
        this.beanFactory = beanFactory;
        this.qualificationsRepository = qualificationsRepository;
    }

    public Map<String, Object> generateReport(TestRun testRun, Report report, Map<String, String> queryParameters, Date startDate, Date endDate) {
        if (report != null) {
            Map<String, Object> resultObject = this.prepareResultObject(report, queryParameters, startDate, endDate);
            resultObject.put("report", report.compute(testRun, this.testRunsRepository));
            return resultObject;
        }
        return Collections.emptyMap();
    }

    public Map<String, Object> generateReport(TestSpecificationSet testSpecificationSet, Report report, Map<String, String> queryParameters, Date startDate, Date endDate) {
        if (report != null) {
            Map<String, Object> resultObject = this.prepareResultObject(report, queryParameters, startDate, endDate);
            resultObject.put("report", report.computeForTestSet(this.testRunsRepository, this.qualificationsRepository, testSpecificationSet));
            return resultObject;
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> prepareResultObject(Report report, Map<String, String> queryParameters, Date startDate, Date endDate) {
        this.beanFactory.autowireBean((Object)report);
        report.addAttribute("query_parameters", queryParameters);
        report.addAttribute("start_date", startDate);
        report.addAttribute("end_date", endDate);
        if (queryParameters.containsKey("tags")) {
            report.addAttribute("tags", Splitter.on((String)";").omitEmptyStrings().splitToList((CharSequence)queryParameters.get("tags")));
        } else {
            report.addAttribute("tags", Collections.emptyList());
        }
        TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
        resultObject.put("type", report.getReportType().toLowerCase());
        return resultObject;
    }

    public Report createReport(String reportName) {
        return (Report)DescriptorRegistry.getDescriptor((String)reportName).newInstance(UUID.randomUUID().toString());
    }
}

