/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.requests;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.util.GenericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTestResultsRequest
implements AutoCloseable,
Closeable {
    public static final MediaType ZIP_TYPE = MediaType.valueOf((String)"application/zip");
    private static final Logger LOG = LoggerFactory.getLogger(ImportTestResultsRequest.class);
    private InputStream testResultStream;
    final Map<String, Object> metadata = new HashMap<String, Object>();

    public ImportTestResultsRequest(MultipartInput parts) {
        if (parts.getParts().size() < 1 || parts.getParts().size() > 2) {
            throw new IllegalArgumentException("Expect 1 or 2 multipart parts: a ZIP file (application/zip) and an optional JSON meta data (application/json)");
        }
        try {
            for (InputPart part : parts.getParts()) {
                if (MediaType.APPLICATION_JSON_TYPE.isCompatible(part.getMediaType())) {
                    this.metadata.putAll((Map)part.getBody((GenericType)new GenericType<Map<String, Object>>(){}));
                    LOG.debug("import metadata={}", this.metadata);
                    continue;
                }
                if (ZIP_TYPE.isCompatible(part.getMediaType())) {
                    if (this.testResultStream != null) {
                        throw new IllegalArgumentException("Received multiple zip parts. Should receive exactly one");
                    }
                    this.testResultStream = (InputStream)part.getBody((GenericType)new GenericType<InputStream>(){});
                    continue;
                }
                throw new IllegalArgumentException(String.format("Received unsupported media type [%s] for multipart item", part.getMediaType()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The multipart input did could not be used to extract test result data for import: " + e.getMessage(), e);
        }
        if (this.testResultStream == null) {
            throw new IllegalArgumentException("No test results received. Expected a zip file (application/zip) containing test results");
        }
    }

    public InputStream getInputStream() {
        return this.testResultStream;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void validateMetadata() {
        List keysWithAtSign = this.metadata.keySet().stream().filter(k -> k.startsWith("@")).collect(Collectors.toList());
        if (!keysWithAtSign.isEmpty()) {
            throw new IllegalArgumentException(String.format("Metadata keys starting with @ are prohibited for XL TestView only. Keys are: %s", keysWithAtSign));
        }
    }

    @Override
    public void close() {
        if (this.testResultStream != null) {
            Closeables.closeQuietly((Closeable)this.testResultStream);
        }
    }
}

