/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.google.common.collect.ComparisonChain;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xltest.repository.TestToolRepository;
import com.xebialabs.xltest.service.TestResultLocator;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/testtools")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class TestToolsInternalController {
    private static final Logger LOG = LoggerFactory.getLogger(TestToolsInternalController.class);
    private final TestToolRepository testToolRepository;

    @Autowired
    public TestToolsInternalController(TestToolRepository testToolRepository) {
        this.testToolRepository = testToolRepository;
    }

    @GET
    public Response getTestToolRepository() {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        List<Descriptor> scriptedTestTools = this.testToolRepository.getTestToolConfigurations();
        Collections.sort(scriptedTestTools, (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.getLabel()), (Comparable)((Object)o2.getLabel())).result());
        for (Descriptor testTool : scriptedTestTools) {
            String pattern = testTool.getPropertyDescriptor("defaultSearchPattern").getDefaultValue().toString();
            String name = testTool.getLabel();
            String category = testTool.getPropertyDescriptor("category").getDefaultValue().toString();
            jsonArrayBuilder.add((JsonValue)Json.createObjectBuilder().add("name", name).add("pattern", pattern).add("category", category).add("type", testTool.getType().toString()).build());
        }
        JsonArray jsonArray = jsonArrayBuilder.build();
        return Response.ok((Object)jsonArray.toString()).build();
    }

    @GET
    @Path(value="{testTool}/paths")
    public Response validateHostConfiguration(@PathParam(value="testTool") String testTool, @QueryParam(value="type") String type, @QueryParam(value="address") String address, @QueryParam(value="username") String username, @QueryParam(value="password") String password, @QueryParam(value="path") String path, @QueryParam(value="pattern") String pattern) {
        SortedSet<OverthereFile> files;
        try {
            files = new TestResultLocator().forHost(type, address, username, password).locate(path, pattern);
        }
        catch (Exception e) {
            LOG.info("Unable to validate host configuration. Type: {}, address: {}, username: {}, path: {}, testtool: {}", new Object[]{type, address, username, path, testTool, e});
            JsonObject json = Json.createObjectBuilder().add("error", e.getMessage()).build();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
        if (files != null && !files.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            files.stream().map(OverthereFile::getPath).forEach(arg_0 -> ((JsonArrayBuilder)jsonArrayBuilder).add(arg_0));
            JsonObjectBuilder jsonBuilder = Json.createObjectBuilder();
            jsonBuilder.add("paths", (JsonValue)jsonArrayBuilder.build());
            JsonObject jsonObject = jsonBuilder.build();
            return Response.ok((Object)jsonObject.toString()).build();
        }
        JsonObject json = Json.createObjectBuilder().add("error", String.format("No test results found in path %s", path)).build();
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)json.toString()).build();
    }
}

