/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.xltest.Synthetic;
import com.xebialabs.xltest.domain.ScriptedConfigurationItem;
import com.xebialabs.xltest.repository.EventRepository;
import com.xebialabs.xltest.repository.RepositoryInitializer;
import com.xebialabs.xltest.repository.ScriptExecutionException;
import com.xebialabs.xltest.repository.ScriptExecutor;
import com.xebialabs.xltest.repository.ScriptExecutorHolder;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javax.script.SimpleScriptContext;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DataLoader.class);
    private final RepositoryService repositoryService;
    private final EventRepository eventRepository;
    private final Client client;

    public DataLoader(RepositoryService repositoryService, Client client, EventRepository eventRepository) {
        this.repositoryService = repositoryService;
        this.client = client;
        this.eventRepository = eventRepository;
    }

    public boolean loadBasicData() {
        if (this.basicDataHasBeenLoadedAlready()) {
            return false;
        }
        RepositoryInitializer.initializeRepositoryDirectories(this.repositoryService);
        return true;
    }

    public boolean basicDataHasBeenLoadedAlready() {
        return this.repositoryService.exists(Synthetic.PROJECT.jcrDirectory);
    }

    public void loadDemoData(String generateScriptPath) {
        LOG.debug("Loading demo data. Checking if the event repository contains data");
        Long nrOfEventsInRepository = this.eventRepository.countAll();
        if (nrOfEventsInRepository > 0L) {
            LOG.debug("Will not load demo data because there is are {} events in the repository (expected 0)", (Object)nrOfEventsInRepository);
            return;
        }
        LOG.debug("No events in repository. Continuing...");
        try {
            ScriptExecutor executor = ScriptExecutorHolder.getScriptExecutor();
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            try (PrintWriter executionLog = new PrintWriter(new ScriptedConfigurationItem.LogWriter("DemoData"));){
                scriptContext.setWriter(executionLog);
                scriptContext.setErrorWriter(executionLog);
                scriptContext.setAttribute("repository", this.repositoryService, 100);
                scriptContext.setAttribute("logger", LoggerFactory.getLogger((String)"Script"), 100);
                scriptContext.setAttribute("client", this.client, 100);
                scriptContext.setAttribute("eventRepository", this.eventRepository, 100);
                scriptContext.setAttribute("operatingSystemFamily", OperatingSystemFamily.getLocalHostOperatingSystemFamily(), 100);
                executor.evalScriptFile(generateScriptPath, scriptContext);
            }
        }
        catch (ScriptExecutionException | FileNotFoundException e) {
            LOG.warn("Unable to fully provision XL TestView", (Throwable)e);
            throw new RuntimeException(String.format("Unable to load demo data, disable with %s=false. %s", "xlt.load-demo-data", e.getMessage()));
        }
    }
}

