/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Subscription;
import rx.subscriptions.Subscriptions;

public final class RefCountSubscription
implements Subscription {
    private final Subscription actual;
    static final State EMPTY_STATE = new State(false, 0);
    volatile State state = EMPTY_STATE;
    static final AtomicReferenceFieldUpdater<RefCountSubscription, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RefCountSubscription.class, State.class, "state");

    public RefCountSubscription(Subscription s) {
        if (s == null) {
            throw new IllegalArgumentException("s");
        }
        this.actual = s;
    }

    public Subscription get() {
        State newState;
        State oldState;
        do {
            oldState = this.state;
            if (!oldState.isUnsubscribed) continue;
            return Subscriptions.unsubscribed();
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState = oldState.addChild()));
        return new InnerSubscription(this);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.state.isUnsubscribed;
    }

    @Override
    public void unsubscribe() {
        State newState;
        State oldState;
        do {
            oldState = this.state;
            if (!oldState.isUnsubscribed) continue;
            return;
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState = oldState.unsubscribe()));
        this.unsubscribeActualIfApplicable(newState);
    }

    private void unsubscribeActualIfApplicable(State state) {
        if (state.isUnsubscribed && state.children == 0) {
            this.actual.unsubscribe();
        }
    }

    void unsubscribeAChild() {
        State newState;
        State oldState;
        while (!STATE_UPDATER.compareAndSet(this, oldState = this.state, newState = oldState.removeChild())) {
        }
        this.unsubscribeActualIfApplicable(newState);
    }

    private static final class InnerSubscription
    implements Subscription {
        final RefCountSubscription parent;
        volatile int innerDone;
        static final AtomicIntegerFieldUpdater<InnerSubscription> INNER_DONE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(InnerSubscription.class, "innerDone");

        public InnerSubscription(RefCountSubscription parent) {
            this.parent = parent;
        }

        @Override
        public void unsubscribe() {
            if (INNER_DONE_UPDATER.compareAndSet(this, 0, 1)) {
                this.parent.unsubscribeAChild();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerDone != 0;
        }
    }

    private static final class State {
        final boolean isUnsubscribed;
        final int children;

        State(boolean u, int c) {
            this.isUnsubscribed = u;
            this.children = c;
        }

        State addChild() {
            return new State(this.isUnsubscribed, this.children + 1);
        }

        State removeChild() {
            return new State(this.isUnsubscribed, this.children - 1);
        }

        State unsubscribe() {
            return new State(true, this.children);
        }
    }
}

