/*
 * Decompiled with CFR 0.152.
 */
package spray.http;

import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import spray.http.ErrorInfo;
import spray.http.IllegalUriException;
import spray.http.Rendering;
import spray.http.StringRendering;
import spray.http.Uri;
import spray.http.Uri$Authority$;
import spray.http.Uri$Empty$;
import spray.http.Uri$Host$;
import spray.http.Uri$ParsingMode$Relaxed$;
import spray.http.Uri$Path$;
import spray.http.Uri$Path$Empty$;
import spray.http.Uri$Query$Empty$;
import spray.http.parser.ParserInput;
import spray.http.parser.ParserInput$;
import spray.http.parser.UriParser;
import spray.http.parser.UriParser$;
import spray.util.package$;

public final class Uri$
implements Serializable {
    public static final Uri$ MODULE$;
    private final Uri $div;
    private final Map<String, Object> defaultPorts;

    static {
        new Uri$();
    }

    public Uri $div() {
        return this.$div;
    }

    public Uri apply(String input) {
        return this.apply(ParserInput$.MODULE$.apply(input), package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input) {
        return this.apply(input, package$.MODULE$.UTF8(), Uri$ParsingMode$Relaxed$.MODULE$);
    }

    public Uri apply(ParserInput input, Uri.ParsingMode mode) {
        return this.apply(input, package$.MODULE$.UTF8(), mode);
    }

    public Uri apply(ParserInput input, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(input, charset2, mode).parseReference();
    }

    public Uri apply(String scheme, Uri.Authority authority, Uri.Path path, Uri.Query query, Option<String> fragment) {
        Uri.Path p = this.verifyPath(path, scheme, authority.host());
        return this.create(this.normalizeScheme(scheme), authority.normalizedFor(scheme), scheme.isEmpty() ? p : this.collapseDotSegments(p), query, fragment);
    }

    public String apply$default$1() {
        return "";
    }

    public Uri.Authority apply$default$2() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public Uri.Path apply$default$3() {
        return Uri$Path$Empty$.MODULE$;
    }

    public Uri.Query apply$default$4() {
        return Uri$Query$Empty$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Uri from(String scheme, String userinfo, String host, int port, String path, Uri.Query query, Option<String> fragment, Uri.ParsingMode mode) {
        return this.apply(scheme, new Uri.Authority(Uri$Host$.MODULE$.apply(host, package$.MODULE$.UTF8(), mode), this.normalizePort(port, scheme), userinfo), Uri$Path$.MODULE$.apply(path, Uri$Path$.MODULE$.apply$default$2()), query, fragment);
    }

    public String from$default$1() {
        return "";
    }

    public String from$default$2() {
        return "";
    }

    public String from$default$3() {
        return "";
    }

    public int from$default$4() {
        return 0;
    }

    public String from$default$5() {
        return "";
    }

    public Uri.Query from$default$6() {
        return Uri$Query$Empty$.MODULE$;
    }

    public Option<String> from$default$7() {
        return None$.MODULE$;
    }

    public Uri.ParsingMode from$default$8() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAbsolute(ParserInput input, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(input, charset2, mode).parseAbsolute();
    }

    public Charset parseAbsolute$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAbsolute$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseAndResolve(ParserInput string, Uri base, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(string, charset2, mode).parseAndResolveReference(base);
    }

    public Charset parseAndResolve$default$3() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseAndResolve$default$4() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri parseHttpRequestTarget(ParserInput requestTarget, Charset charset2, Uri.ParsingMode mode) {
        return new UriParser(requestTarget, charset2, mode).parseHttpRequestTarget();
    }

    public Charset parseHttpRequestTarget$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode parseHttpRequestTarget$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public String normalize(ParserInput uri, Charset charset2, Uri.ParsingMode mode) {
        return this.apply(uri, charset2, mode).render(new StringRendering(), charset2).get();
    }

    public Charset normalize$default$2() {
        return package$.MODULE$.UTF8();
    }

    public Uri.ParsingMode normalize$default$3() {
        return Uri$ParsingMode$Relaxed$.MODULE$;
    }

    public Uri effectiveHttpRequestUri(String scheme, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment, boolean securedConnection, Uri.Host hostHeaderHost, int hostHeaderPort, Uri.Authority defaultAuthority) {
        String _scheme = scheme;
        Uri.Host _host = host;
        int _port = port;
        if (_scheme.isEmpty()) {
            _scheme = this.httpScheme(securedConnection);
            if (_host.isEmpty()) {
                if (hostHeaderHost.isEmpty()) {
                    _host = defaultAuthority.host();
                    _port = defaultAuthority.port();
                } else {
                    _host = hostHeaderHost;
                    _port = hostHeaderPort;
                }
            }
        }
        return this.create(_scheme, "", _host, _port, this.collapseDotSegments(path), query, fragment);
    }

    public Uri.Authority effectiveHttpRequestUri$default$10() {
        return Uri$Authority$.MODULE$.Empty();
    }

    public String httpScheme(boolean securedConnection) {
        return securedConnection ? "https" : "http";
    }

    public boolean httpScheme$default$1() {
        return false;
    }

    public Map<String, Object> defaultPorts() {
        return this.defaultPorts;
    }

    public Uri resolve(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment, Uri base) {
        Uri uri;
        Predef$.MODULE$.require(base.isAbsolute(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Resolution base Uri must be absolute";
            }
        });
        if (scheme.isEmpty()) {
            if (host.isEmpty()) {
                if (path.isEmpty()) {
                    Uri.Query q = query.isEmpty() ? base.query() : query;
                    uri = this.create(base.scheme(), base.authority(), base.path(), q, fragment);
                } else {
                    Uri.Path p = path.startsWithSlash() ? path : this.mergePaths$1(base, path);
                    uri = this.create(base.scheme(), base.authority(), this.collapseDotSegments(p), query, fragment);
                }
            } else {
                uri = this.create(base.scheme(), userinfo, host, port, this.collapseDotSegments(path), query, fragment);
            }
        } else {
            uri = this.create(scheme, userinfo, host, port, this.collapseDotSegments(path), query, fragment);
        }
        return uri;
    }

    public Rendering encode(Rendering r, String string, Charset charset2, int keep, boolean replaceSpaces) {
        boolean asciiCompatible = this.isAsciiCompatible(charset2);
        return this.rec$1(this.rec$default$1$1(), r, string, charset2, keep, replaceSpaces, asciiCompatible);
    }

    public boolean encode$default$5() {
        return false;
    }

    public String decode(String string, Charset charset2) {
        String string2;
        int ix = string.indexOf(37);
        if (ix >= 0) {
            String x$99 = string;
            Charset x$100 = charset2;
            int x$101 = ix;
            java.lang.StringBuilder x$102 = this.decode$default$4(x$99, x$100, x$101);
            string2 = this.decode(x$99, x$100, x$101, x$102);
        } else {
            string2 = string;
        }
        return string2;
    }

    public String decode(String string, Charset charset2, int ix, java.lang.StringBuilder sb) {
        block3: while (ix < string.length()) {
            java.lang.StringBuilder stringBuilder;
            int lastPercentSignIndexPlus3;
            char c = string.charAt(ix);
            switch (c) {
                default: {
                    sb = sb.append(c);
                    ++ix;
                    continue block3;
                }
                case '%': 
            }
            for (lastPercentSignIndexPlus3 = ix + 3; lastPercentSignIndexPlus3 < string.length() && string.charAt(lastPercentSignIndexPlus3) == '%'; lastPercentSignIndexPlus3 += 3) {
            }
            int bytesCount = (lastPercentSignIndexPlus3 - ix) / 3;
            byte[] bytes2 = new byte[bytesCount];
            if (this.decodeBytes$1(this.decodeBytes$default$1$1(), this.decodeBytes$default$2$1(), string, ix, bytesCount, bytes2) >> 7 == 0 && this.isAsciiCompatible(charset2)) {
                this.appendBytes$1(this.appendBytes$default$1$1(), sb, bytesCount, bytes2);
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = sb.append(new String(bytes2, charset2));
            }
            ix = lastPercentSignIndexPlus3;
        }
        return sb.toString();
    }

    public java.lang.StringBuilder decode$default$4(String string, Charset charset2, int ix) {
        return new java.lang.StringBuilder(string.length()).append(string, 0, ix);
    }

    public String normalizeScheme(String scheme) {
        String string;
        int n = this.verify$1(this.verify$default$1$1(scheme), this.verify$default$2$1(), this.verify$default$3$1(), scheme);
        switch (n) {
            default: {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid URI scheme, unexpected character at pos ", " ('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToCharacter((char)scheme.charAt(n))})), this.fail$default$2());
            }
            case -1: {
                string = scheme;
                break;
            }
            case -2: {
                string = scheme.toLowerCase();
            }
        }
        return string;
    }

    public int normalizePort(int port, String scheme) {
        if (port >> 16 == 0) {
            return port != 0 && BoxesRunTime.unboxToInt((Object)this.defaultPorts().apply((Object)scheme)) == port ? 0 : port;
        }
        throw this.fail(new StringBuilder().append((Object)"Invalid port ").append((Object)BoxesRunTime.boxToInteger((int)port)).toString(), this.fail$default$2());
    }

    public Uri.Path verifyPath(Uri.Path path, String scheme, Uri.Host host) {
        if (host.isEmpty()) {
            if (path.startsWithSlash() && path.tail().startsWithSlash()) {
                throw this.fail("The path of an URI without authority must not begin with \"//\"", this.fail$default$2());
            }
        } else if (path.startsWithSegment()) {
            throw this.fail("The path of an URI containing an authority must either be empty or start with a '/' (slash) character", this.fail$default$2());
        }
        return path;
    }

    public Uri.Path collapseDotSegments(Uri.Path path) {
        return this.hasDotOrDotDotSegment$1(path) ? this.process$1(path, this.process$default$2$1()) : path;
    }

    public Nothing$ fail(String summary, String detail) {
        throw new IllegalUriException(new ErrorInfo(summary, detail));
    }

    public String fail$default$2() {
        return "";
    }

    public Uri create(String scheme, String userinfo, Uri.Host host, int port, Uri.Path path, Uri.Query query, Option<String> fragment) {
        return this.create(scheme, new Uri.Authority(host, this.normalizePort(port, scheme), userinfo), path, query, fragment);
    }

    public Uri create(String scheme, Uri.Authority authority, Uri.Path path, Uri.Query query, Option<String> fragment) {
        return path.isEmpty() && scheme.isEmpty() && authority.isEmpty() && query.isEmpty() && fragment.isEmpty() ? Uri$Empty$.MODULE$ : new Uri(scheme, authority, path, query, (Option)fragment){

            public boolean isEmpty() {
                return false;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAsciiCompatible(Charset cs) {
        Charset charset2 = cs;
        Charset charset3 = package$.MODULE$.UTF8();
        if (charset2 == null) {
            if (charset3 == null) return true;
        } else if (((Object)charset2).equals(charset3)) return true;
        Charset charset4 = cs;
        Charset charset5 = package$.MODULE$.ISO88591();
        if (charset4 == null) {
            if (charset5 == null) return true;
        } else if (((Object)charset4).equals(charset5)) return true;
        Charset charset6 = cs;
        Charset charset7 = package$.MODULE$.US_ASCII();
        if (charset6 != null) {
            if (!((Object)charset6).equals(charset7)) return false;
            return true;
        }
        if (charset7 == null) return true;
        return false;
    }

    public Option<Tuple5<String, Uri.Authority, Uri.Path, Uri.Query, Option<String>>> unapply(Uri x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.scheme(), (Object)x$0.authority(), (Object)x$0.path(), (Object)x$0.query(), x$0.fragment()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Uri.Path replaceLastSegment$1(Uri.Path p, Uri.Path replacement) {
        Uri.Path path;
        block5: {
            Uri.Path path2;
            block3: {
                block4: {
                    block2: {
                        Uri.Path.Segment segment;
                        Uri.Path.SlashOrEmpty slashOrEmpty;
                        path = p;
                        boolean bl = Uri$Path$Empty$.MODULE$.equals(path) ? true : path instanceof Uri.Path.Segment && Uri$Path$Empty$.MODULE$.equals(slashOrEmpty = (segment = (Uri.Path.Segment)path).tail());
                        if (!bl) break block2;
                        path2 = replacement;
                        break block3;
                    }
                    if (!(path instanceof Uri.Path.Segment)) break block4;
                    Uri.Path.Segment segment = (Uri.Path.Segment)path;
                    String string = segment.head();
                    Uri.Path.SlashOrEmpty tail = segment.tail();
                    String string2 = string;
                    path2 = this.replaceLastSegment$1(tail, replacement).$colon$colon(string2);
                    break block3;
                }
                if (!(path instanceof Uri.Path.Slash)) break block5;
                Uri.Path.Slash slash = (Uri.Path.Slash)path;
                Uri.Path tail = slash.tail();
                path2 = new Uri.Path.Slash(this.replaceLastSegment$1(tail, replacement));
            }
            return path2;
        }
        throw new MatchError((Object)path);
    }

    private final Uri.Path mergePaths$1(Uri base, Uri.Path path) {
        return !base.authority().isEmpty() && base.path().isEmpty() ? new Uri.Path.Slash(path) : this.replaceLastSegment$1(base.path(), path);
    }

    public final void spray$http$Uri$$appendEncoded$1(byte by, Rendering r$1) {
        r$1.$tilde$tilde('%').$tilde$tilde(UriParser$.MODULE$.hexDigit(by >>> 4)).$tilde$tilde(UriParser$.MODULE$.hexDigit(by));
    }

    private final void append$4(String s2, Rendering r$1, Charset charset$1) {
        Predef$.MODULE$.byteArrayOps(s2.getBytes(charset$1)).foreach((Function1)new Serializable(r$1){
            public static final long serialVersionUID = 0L;
            private final Rendering r$1;

            public final void apply(byte by) {
                Uri$.MODULE$.spray$http$Uri$$appendEncoded$1(by, this.r$1);
            }
            {
                this.r$1 = r$1;
            }
        });
    }

    private final Rendering rec$1(int ix, Rendering r$1, String string$1, Charset charset$1, int keep$1, boolean replaceSpaces$1, boolean asciiCompatible$1) {
        while (ix < string$1.length()) {
            int n;
            char c = string$1.charAt(ix);
            if (UriParser$.MODULE$.is(c, keep$1)) {
                r$1.$tilde$tilde(c);
                n = 1;
            } else if (' ' == c && replaceSpaces$1) {
                r$1.$tilde$tilde('+');
                n = 1;
            } else if (c <= '\u007f' && asciiCompatible$1) {
                this.spray$http$Uri$$appendEncoded$1((byte)c, r$1);
                n = 1;
            } else {
                int n2;
                if (Character.isHighSurrogate(c)) {
                    this.append$4(new String(new int[]{string$1.codePointAt(ix)}, 0, 1), r$1, charset$1);
                    n2 = 2;
                } else {
                    this.append$4(((Object)BoxesRunTime.boxToCharacter((char)c)).toString(), r$1, charset$1);
                    n2 = 1;
                }
                n = n2;
            }
            int charSize = n;
            ix += charSize;
        }
        return r$1;
    }

    private final int rec$default$1$1() {
        return 0;
    }

    private final int intValueOfHexChar$1(int j, String string$3) {
        char c = string$3.charAt(j);
        if (UriParser$.MODULE$.is(c, 124)) {
            return UriParser$.MODULE$.hexValue(c);
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Illegal percent-encoding at pos ").append((Object)BoxesRunTime.boxToInteger((int)j)).toString());
    }

    private final int intValueOfHexWord$1(int i, String string$3) {
        return this.intValueOfHexChar$1(i, string$3) * 16 + this.intValueOfHexChar$1(i + 1, string$3);
    }

    private final int decodeBytes$1(int i, int oredBytes, String string$3, int ix$1, int bytesCount$1, byte[] bytes$1) {
        while (i < bytesCount$1) {
            int n = this.intValueOfHexWord$1(ix$1 + 3 * i + 1, string$3);
            bytes$1[i] = (byte)n;
            oredBytes |= n;
            ++i;
        }
        return oredBytes;
    }

    private final int decodeBytes$default$1$1() {
        return 0;
    }

    private final int decodeBytes$default$2$1() {
        return 0;
    }

    private final void appendBytes$1(int i, java.lang.StringBuilder sb$1, int bytesCount$1, byte[] bytes$1) {
        while (i < bytesCount$1) {
            sb$1.append((char)bytes$1[i]);
            ++i;
        }
    }

    private final int appendBytes$default$1$1() {
        return 0;
    }

    private final int verify$1(int ix, int allowed, boolean allLower, String scheme$2) {
        int n;
        block2: {
            while (ix >= 0) {
                char c = scheme$2.charAt(ix);
                if (UriParser$.MODULE$.is(c, allowed)) {
                    allLower = allLower && !UriParser$.MODULE$.is(c, 2);
                    allowed = 114719;
                    --ix;
                    continue;
                }
                n = ix;
                break block2;
            }
            n = allLower ? -1 : -2;
        }
        return n;
    }

    private final int verify$default$1$1(String scheme$2) {
        return scheme$2.length() - 1;
    }

    private final int verify$default$2$1() {
        return 3;
    }

    private final boolean verify$default$3$1() {
        return true;
    }

    private final boolean hasDotOrDotDotSegment$1(Uri.Path p) {
        while (true) {
            block5: {
                boolean bl;
                block4: {
                    Uri.Path.Segment segment;
                    String string;
                    Uri.Path.Segment segment2;
                    String string2;
                    Uri.Path path;
                    block3: {
                        if (!Uri$Path$Empty$.MODULE$.equals(path = p)) break block3;
                        bl = false;
                        break block4;
                    }
                    boolean bl2 = path instanceof Uri.Path.Segment && ".".equals(string2 = (segment2 = (Uri.Path.Segment)path).head()) ? true : path instanceof Uri.Path.Segment && "..".equals(string = (segment = (Uri.Path.Segment)path).head());
                    if (!bl2) break block5;
                    bl = true;
                }
                return bl;
            }
            p = p.tail();
        }
    }

    private final Uri.Path process$1(Uri.Path input, Uri.Path output) {
        Uri.Path path;
        while (true) {
            Uri.Path path2;
            boolean bl = false;
            Uri.Path.Segment segment = null;
            boolean bl2 = false;
            Uri.Path.Slash slash = null;
            path = input;
            if (Uri$Path$Empty$.MODULE$.equals(path)) {
                Uri.Path path3 = output.reverse();
                return path3;
            }
            if (path instanceof Uri.Path.Segment) {
                bl = true;
                segment = (Uri.Path.Segment)path;
                String string = segment.head();
                Uri.Path.SlashOrEmpty slashOrEmpty = segment.tail();
                boolean bl3 = ".".equals(string) ? true : "..".equals(string);
                if (bl3 && slashOrEmpty instanceof Uri.Path.Slash) {
                    Uri.Path tail;
                    Uri.Path.Slash slash2 = (Uri.Path.Slash)slashOrEmpty;
                    input = tail = slash2.tail();
                    continue;
                }
            }
            if (path instanceof Uri.Path.Slash) {
                bl2 = true;
                slash = (Uri.Path.Slash)path;
                Uri.Path path4 = slash.tail();
                if (path4 instanceof Uri.Path.Segment) {
                    Uri.Path.Segment segment2 = (Uri.Path.Segment)path4;
                    String string = segment2.head();
                    Uri.Path.SlashOrEmpty tail = segment2.tail();
                    if (".".equals(string)) {
                        input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                        continue;
                    }
                }
            }
            if (bl2 && (path2 = slash.tail()) instanceof Uri.Path.Segment) {
                Uri.Path.Segment segment3 = (Uri.Path.Segment)path2;
                String string = segment3.head();
                Uri.Path.SlashOrEmpty tail = segment3.tail();
                if ("..".equals(string)) {
                    output = output.startsWithSegment() ? (output.tail().startsWithSlash() ? output.tail().tail() : tail) : output;
                    input = tail.isEmpty() ? Uri$Path$.MODULE$.$div() : tail;
                    continue;
                }
            }
            if (bl) {
                String string = segment.head();
                Uri.Path.SlashOrEmpty tail = segment.tail();
                boolean bl4 = ".".equals(string) ? true : "..".equals(string);
                if (bl4) {
                    input = tail;
                    continue;
                }
            }
            if (bl2) {
                Uri.Path tail = slash.tail();
                output = new Uri.Path.Slash(output);
                input = tail;
                continue;
            }
            if (!bl) break;
            String string = segment.head();
            Uri.Path.SlashOrEmpty tail = segment.tail();
            String string2 = string;
            output = output.$colon$colon(string2);
            input = tail;
        }
        throw new MatchError((Object)path);
    }

    private final Uri.Path process$default$2$1() {
        return Uri$Path$Empty$.MODULE$;
    }

    private Uri$() {
        MODULE$ = this;
        this.$div = this.apply("/");
        this.defaultPorts = ((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ftp"), (Object)BoxesRunTime.boxToInteger((int)21)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssh"), (Object)BoxesRunTime.boxToInteger((int)22)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"telnet"), (Object)BoxesRunTime.boxToInteger((int)23)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"smtp"), (Object)BoxesRunTime.boxToInteger((int)25)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"domain"), (Object)BoxesRunTime.boxToInteger((int)53)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tftp"), (Object)BoxesRunTime.boxToInteger((int)69)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http"), (Object)BoxesRunTime.boxToInteger((int)80)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pop3"), (Object)BoxesRunTime.boxToInteger((int)110)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nntp"), (Object)BoxesRunTime.boxToInteger((int)119)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"imap"), (Object)BoxesRunTime.boxToInteger((int)143)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snmp"), (Object)BoxesRunTime.boxToInteger((int)161)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ldap"), (Object)BoxesRunTime.boxToInteger((int)389)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"https"), (Object)BoxesRunTime.boxToInteger((int)443)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"imaps"), (Object)BoxesRunTime.boxToInteger((int)993)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nfs"), (Object)BoxesRunTime.boxToInteger((int)2049))}))).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)-1));
    }
}

