/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.FieldDataFunctionValues;

class FieldDataValueSource
extends ValueSource {
    IndexFieldData<?> fieldData;

    FieldDataValueSource(IndexFieldData<?> d) {
        this.fieldData = d;
    }

    public FunctionValues getValues(Map context, AtomicReaderContext leaf) throws IOException {
        Object leafData = this.fieldData.load(leaf);
        assert (leafData instanceof AtomicNumericFieldData);
        return new FieldDataFunctionValues(this, (AtomicNumericFieldData)leafData);
    }

    public boolean equals(Object other) {
        return this.fieldData.equals(other);
    }

    public int hashCode() {
        return this.fieldData.hashCode();
    }

    public String description() {
        return "field(" + this.fieldData.getFieldNames().toString() + ")";
    }
}

