/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.fielddata.AtomicParentChildFieldData;
import org.elasticsearch.index.fielddata.IndexParentChildFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.search.child.ConstantScorer;

public class ParentConstantScoreQuery
extends Query {
    private final ParentChildIndexFieldData parentChildIndexFieldData;
    private Query originalParentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private Query rewrittenParentQuery;
    private IndexReader rewriteIndexReader;

    public ParentConstantScoreQuery(ParentChildIndexFieldData parentChildIndexFieldData, Query parentQuery, String parentType, Filter childrenFilter) {
        this.parentChildIndexFieldData = parentChildIndexFieldData;
        this.originalParentQuery = parentQuery;
        this.parentType = parentType;
        this.childrenFilter = childrenFilter;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.rewrittenParentQuery == null) {
            this.rewrittenParentQuery = this.originalParentQuery.rewrite(reader);
            this.rewriteIndexReader = reader;
        }
        return this;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenParentQuery.extractTerms(terms);
    }

    public Query clone() {
        ParentConstantScoreQuery q = (ParentConstantScoreQuery)super.clone();
        q.originalParentQuery = this.originalParentQuery.clone();
        if (q.rewrittenParentQuery != null) {
            q.rewrittenParentQuery = this.rewrittenParentQuery.clone();
        }
        return q;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        IndexParentChildFieldData globalIfd = this.parentChildIndexFieldData.loadGlobal(searcher.getIndexReader());
        assert (this.rewrittenParentQuery != null);
        assert (this.rewriteIndexReader == searcher.getIndexReader()) : "not equal, rewriteIndexReader=" + this.rewriteIndexReader + " searcher.getIndexReader()=" + searcher.getIndexReader();
        List leaves = searcher.getIndexReader().leaves();
        if (globalIfd == null || leaves.isEmpty()) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        AtomicParentChildFieldData afd = (AtomicParentChildFieldData)globalIfd.load((AtomicReaderContext)leaves.get(0));
        SortedDocValues globalValues = afd.getOrdinalsValues(this.parentType);
        long maxOrd = globalValues.getValueCount();
        if (maxOrd == 0L) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        Query parentQuery = this.rewrittenParentQuery;
        ParentOrdsCollector collector = new ParentOrdsCollector(globalIfd, maxOrd, this.parentType);
        IndexSearcher indexSearcher = new IndexSearcher(searcher.getIndexReader());
        indexSearcher.setSimilarity(searcher.getSimilarity());
        indexSearcher.search(parentQuery, (Collector)collector);
        if (collector.parentCount() == 0L) {
            return Queries.newMatchNoDocsQuery().createWeight(searcher);
        }
        return new ChildrenWeight(this.childrenFilter, collector, globalIfd);
    }

    public int hashCode() {
        int result = this.originalParentQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ParentConstantScoreQuery that = (ParentConstantScoreQuery)((Object)obj);
        if (!this.originalParentQuery.equals((Object)that.originalParentQuery)) {
            return false;
        }
        if (!this.parentType.equals(that.parentType)) {
            return false;
        }
        return this.getBoost() == that.getBoost();
    }

    public String toString(String field) {
        return "parent_filter[" + this.parentType + "](" + this.originalParentQuery + ')';
    }

    private static final class ParentOrdsCollector
    extends NoopCollector {
        private final LongBitSet parentOrds;
        private final IndexParentChildFieldData globalIfd;
        private final String parentType;
        private SortedDocValues globalOrdinals;

        ParentOrdsCollector(IndexParentChildFieldData globalIfd, long maxOrd, String parentType) {
            this.parentOrds = new LongBitSet(maxOrd);
            this.globalIfd = globalIfd;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            long globalOrd;
            if (this.globalOrdinals != null && (globalOrd = (long)this.globalOrdinals.getOrd(doc)) >= 0L) {
                this.parentOrds.set(globalOrd);
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext readerContext) throws IOException {
            this.globalOrdinals = ((AtomicParentChildFieldData)this.globalIfd.load(readerContext)).getOrdinalsValues(this.parentType);
        }

        public long parentCount() {
            return this.parentOrds.cardinality();
        }
    }

    private final class ChildrenDocIdIterator
    extends FilteredDocIdSetIterator {
        private final LongBitSet parentOrds;
        private final SortedDocValues globalOrdinals;

        ChildrenDocIdIterator(DocIdSetIterator innerIterator, LongBitSet parentOrds, SortedDocValues globalOrdinals) {
            super(innerIterator);
            this.parentOrds = parentOrds;
            this.globalOrdinals = globalOrdinals;
        }

        protected boolean match(int docId) {
            int globalOrd = this.globalOrdinals.getOrd(docId);
            if (globalOrd >= 0) {
                return this.parentOrds.get((long)globalOrd);
            }
            return false;
        }
    }

    private final class ChildrenWeight
    extends Weight {
        private final IndexParentChildFieldData globalIfd;
        private final Filter childrenFilter;
        private final LongBitSet parentOrds;
        private float queryNorm;
        private float queryWeight;

        private ChildrenWeight(Filter childrenFilter, ParentOrdsCollector collector, IndexParentChildFieldData globalIfd) {
            this.globalIfd = globalIfd;
            this.childrenFilter = new ApplyAcceptedDocsFilter(childrenFilter);
            this.parentOrds = collector.parentOrds;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ParentConstantScoreQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ParentConstantScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            this.queryWeight = ParentConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm, float topLevelBoost) {
            this.queryNorm = norm * topLevelBoost;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            DocIdSetIterator innerIterator;
            DocIdSet childrenDocIdSet = this.childrenFilter.getDocIdSet(context, acceptDocs);
            if (DocIdSets.isEmpty(childrenDocIdSet)) {
                return null;
            }
            SortedDocValues globalValues = ((AtomicParentChildFieldData)this.globalIfd.load(context)).getOrdinalsValues(ParentConstantScoreQuery.this.parentType);
            if (globalValues != null && (innerIterator = childrenDocIdSet.iterator()) != null) {
                ChildrenDocIdIterator childrenDocIdIterator = new ChildrenDocIdIterator(innerIterator, this.parentOrds, globalValues);
                return ConstantScorer.create((DocIdSetIterator)childrenDocIdIterator, this, this.queryWeight);
            }
            return null;
        }
    }
}

