/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.HasHeaders;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectObjectAssociativeContainer;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;

public class ContextAndHeaderHolder
implements HasContextAndHeaders {
    private ObjectObjectOpenHashMap<Object, Object> context;
    protected Map<String, Object> headers;

    @Override
    public final synchronized <V> V putInContext(Object key, Object value) {
        if (this.context == null) {
            this.context = new ObjectObjectOpenHashMap(2);
        }
        return (V)this.context.put(key, value);
    }

    @Override
    public final synchronized void putAllInContext(ObjectObjectAssociativeContainer<Object, Object> map) {
        if (map == null) {
            return;
        }
        if (this.context == null) {
            this.context = new ObjectObjectOpenHashMap<Object, Object>(map);
        } else {
            this.context.putAll(map);
        }
    }

    @Override
    public final synchronized <V> V getFromContext(Object key) {
        return (V)(this.context != null ? this.context.get(key) : null);
    }

    @Override
    public final synchronized <V> V getFromContext(Object key, V defaultValue) {
        V value = this.getFromContext(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public final synchronized boolean hasInContext(Object key) {
        return this.context != null && this.context.containsKey(key);
    }

    @Override
    public final synchronized int contextSize() {
        return this.context != null ? this.context.size() : 0;
    }

    @Override
    public final synchronized boolean isContextEmpty() {
        return this.context == null || this.context.isEmpty();
    }

    @Override
    public synchronized ImmutableOpenMap<Object, Object> getContext() {
        return this.context != null ? ImmutableOpenMap.copyOf(this.context) : ImmutableOpenMap.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void copyContextFrom(HasContext other) {
        if (other == null) {
            return;
        }
        HasContext hasContext = other;
        synchronized (hasContext) {
            ImmutableOpenMap<Object, Object> otherContext = other.getContext();
            if (otherContext == null) {
                return;
            }
            if (this.context == null) {
                this.context = new ObjectObjectOpenHashMap(otherContext.size());
            }
            this.context.putAll(otherContext);
        }
    }

    @Override
    public HasHeaders putHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
        return this;
    }

    @Override
    public final <V> V getHeader(String key) {
        return (V)(this.headers != null ? this.headers.get(key) : null);
    }

    @Override
    public final boolean hasHeader(String key) {
        return this.headers != null && this.headers.containsKey(key);
    }

    @Override
    public Set<String> getHeaders() {
        return this.headers != null ? this.headers.keySet() : Collections.emptySet();
    }

    @Override
    public void copyHeadersFrom(HasHeaders from) {
        if (from != null && from.getHeaders() != null && !from.getHeaders().isEmpty()) {
            for (String headerName : from.getHeaders()) {
                this.putHeader(headerName, from.getHeader(headerName));
            }
        }
    }

    @Override
    public void copyContextAndHeadersFrom(HasContextAndHeaders other) {
        this.copyContextFrom(other);
        this.copyHeadersFrom(other);
    }
}

