/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.percolate.PercolateRequest;
import org.elasticsearch.action.percolate.PercolateResponse;
import org.elasticsearch.action.percolate.PercolateSourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class PercolateRequestBuilder
extends BroadcastOperationRequestBuilder<PercolateRequest, PercolateResponse, PercolateRequestBuilder, Client> {
    private PercolateSourceBuilder sourceBuilder;

    public PercolateRequestBuilder(Client client) {
        super(client, new PercolateRequest());
    }

    public PercolateRequestBuilder setDocumentType(String type) {
        ((PercolateRequest)this.request).documentType(type);
        return this;
    }

    public PercolateRequestBuilder setRouting(String routing) {
        ((PercolateRequest)this.request).routing(routing);
        return this;
    }

    public PercolateRequestBuilder setRouting(String ... routings) {
        ((PercolateRequest)this.request).routing(Strings.arrayToCommaDelimitedString(routings));
        return this;
    }

    public PercolateRequestBuilder setPreference(String preference) {
        ((PercolateRequest)this.request).preference(preference);
        return this;
    }

    public PercolateRequestBuilder setGetRequest(GetRequest getRequest) {
        ((PercolateRequest)this.request).getRequest(getRequest);
        return this;
    }

    public PercolateRequestBuilder setOnlyCount(boolean onlyCount) {
        ((PercolateRequest)this.request).onlyCount(onlyCount);
        return this;
    }

    public PercolateRequestBuilder setSize(int size) {
        this.sourceBuilder().setSize(size);
        return this;
    }

    public PercolateRequestBuilder setSortByScore(boolean sort) {
        this.sourceBuilder().setSort(sort);
        return this;
    }

    public PercolateRequestBuilder addSort(SortBuilder sort) {
        this.sourceBuilder().addSort(sort);
        return this;
    }

    public PercolateRequestBuilder setScore(boolean score) {
        this.sourceBuilder().setTrackScores(score);
        return this;
    }

    public PercolateRequestBuilder setPercolateDoc(PercolateSourceBuilder.DocBuilder docBuilder) {
        this.sourceBuilder().setDoc(docBuilder);
        return this;
    }

    public PercolateRequestBuilder setPercolateQuery(QueryBuilder queryBuilder) {
        this.sourceBuilder().setQueryBuilder(queryBuilder);
        return this;
    }

    public PercolateRequestBuilder setPercolateFilter(FilterBuilder filterBuilder) {
        this.sourceBuilder().setFilterBuilder(filterBuilder);
        return this;
    }

    public PercolateRequestBuilder setHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.sourceBuilder().setHighlightBuilder(highlightBuilder);
        return this;
    }

    public PercolateRequestBuilder addFacet(FacetBuilder facetBuilder) {
        this.sourceBuilder().addFacet(facetBuilder);
        return this;
    }

    public PercolateRequestBuilder addAggregation(AggregationBuilder aggregationBuilder) {
        this.sourceBuilder().addAggregation(aggregationBuilder);
        return this;
    }

    public PercolateRequestBuilder setSource(PercolateSourceBuilder source) {
        this.sourceBuilder = source;
        return this;
    }

    public PercolateRequestBuilder setSource(Map<String, Object> source) {
        ((PercolateRequest)this.request).source(source);
        return this;
    }

    public PercolateRequestBuilder setSource(Map<String, Object> source, XContentType contentType) {
        ((PercolateRequest)this.request).source(source, contentType);
        return this;
    }

    public PercolateRequestBuilder setSource(String source) {
        ((PercolateRequest)this.request).source(source);
        return this;
    }

    public PercolateRequestBuilder setSource(XContentBuilder sourceBuilder) {
        ((PercolateRequest)this.request).source(sourceBuilder);
        return this;
    }

    public PercolateRequestBuilder setSource(BytesReference source) {
        ((PercolateRequest)this.request).source(source);
        return this;
    }

    public PercolateRequestBuilder setSource(byte[] source) {
        ((PercolateRequest)this.request).source(source);
        return this;
    }

    public PercolateRequestBuilder setSource(byte[] source, int offset, int length) {
        ((PercolateRequest)this.request).source(source, offset, length);
        return this;
    }

    private PercolateSourceBuilder sourceBuilder() {
        if (this.sourceBuilder == null) {
            this.sourceBuilder = new PercolateSourceBuilder();
        }
        return this.sourceBuilder;
    }

    @Override
    public PercolateRequest request() {
        if (this.sourceBuilder != null) {
            ((PercolateRequest)this.request).source(this.sourceBuilder);
        }
        return (PercolateRequest)this.request;
    }

    @Override
    protected void doExecute(ActionListener<PercolateResponse> listener) {
        if (this.sourceBuilder != null) {
            ((PercolateRequest)this.request).source(this.sourceBuilder);
        }
        ((Client)this.client).percolate((PercolateRequest)this.request, listener);
    }
}

