/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.concurrent.Executor;
import org.modeshape.common.collection.ring.BlockingWaitStrategy;
import org.modeshape.common.collection.ring.Consumer;
import org.modeshape.common.collection.ring.Cursor;
import org.modeshape.common.collection.ring.RingBuffer;
import org.modeshape.common.collection.ring.SingleProducerCursor;
import org.modeshape.common.collection.ring.StandardConsumerAdapter;
import org.modeshape.common.collection.ring.WaitStrategy;
import org.modeshape.common.util.CheckArg;

public class RingBufferBuilder<T, C> {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final boolean DEFAULT_GARBAGE_COLLECT_ENTITIES = false;
    public static final String DEFAULT_NAME = "ringbuffer";
    private final Executor executor;
    private final RingBuffer.ConsumerAdapter<T, C> adapter;
    private int bufferSize = 1024;
    private boolean garbageCollect = false;
    private boolean singleProducer = true;
    private String name = "ringbuffer";
    private WaitStrategy waitStrategy;

    public static <T, C> RingBufferBuilder<T, C> withSingleProducer(Executor executor, RingBuffer.ConsumerAdapter<T, C> adapter) {
        return new RingBufferBuilder<T, C>(executor, adapter).singleProducer();
    }

    public static <T, C extends Consumer<T>> RingBufferBuilder<T, C> withSingleProducer(Executor executor, Class<T> entryClass) {
        return new RingBufferBuilder(executor, StandardConsumerAdapter.create()).singleProducer();
    }

    public static <T, C> RingBufferBuilder<T, C> withMultipleProducers(Executor executor, RingBuffer.ConsumerAdapter<T, C> adapter) {
        return new RingBufferBuilder<T, C>(executor, adapter).multipleProducers();
    }

    public static <T, C extends Consumer<T>> RingBufferBuilder<T, C> withMultipleProducers(Executor executor, Class<T> entryClass) {
        return new RingBufferBuilder(executor, StandardConsumerAdapter.create()).multipleProducers();
    }

    protected RingBufferBuilder(Executor executor, RingBuffer.ConsumerAdapter<T, C> adapter) {
        CheckArg.isNotNull(executor, "executor");
        CheckArg.isNotNull(adapter, "adapter");
        this.executor = executor;
        this.adapter = adapter;
    }

    public RingBufferBuilder<T, C> ofSize(int bufferSize) {
        CheckArg.isPositive(bufferSize, "bufferSize");
        CheckArg.isPowerOfTwo(bufferSize, "bufferSize");
        this.bufferSize = bufferSize;
        return this;
    }

    public RingBufferBuilder<T, C> garbageCollect(boolean gcEntries) {
        this.garbageCollect = gcEntries;
        return this;
    }

    public RingBufferBuilder<T, C> waitUsing(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    protected RingBufferBuilder<T, C> singleProducer() {
        this.singleProducer = true;
        return this;
    }

    protected RingBufferBuilder<T, C> multipleProducers() {
        this.singleProducer = false;
        return this;
    }

    public RingBufferBuilder<T, C> named(String bufferName) {
        if (bufferName != null && bufferName.trim().isEmpty()) {
            this.name = bufferName;
        }
        return this;
    }

    public RingBuffer<T, C> build() {
        WaitStrategy waitStrategy = this.waitStrategy;
        if (waitStrategy == null) {
            waitStrategy = this.defaultWaitStrategy();
        }
        Cursor cursor = this.defaultCursor(this.bufferSize, waitStrategy);
        return new RingBuffer<T, C>(this.name, cursor, this.executor, this.adapter, this.garbageCollect, this.singleProducer);
    }

    protected WaitStrategy defaultWaitStrategy() {
        return new BlockingWaitStrategy();
    }

    protected Cursor defaultCursor(int bufferSize, WaitStrategy waitStrategy) {
        return new SingleProducerCursor(bufferSize, waitStrategy);
    }
}

