/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@PublicApiRef
public abstract class DescriptorRegistry {
    private static final Map<DescriptorRegistryId, DescriptorRegistry> REGISTRIES = new LinkedHashMap<DescriptorRegistryId, DescriptorRegistry>();
    private final Map<String, Type> NAME_TYPE_CACHE = new HashMap<String, Type>();
    private final Map<Class<?>, Type> CLASS_TYPE_CACHE = new HashMap();
    private final DescriptorRegistryId id;

    protected DescriptorRegistry(DescriptorRegistryId id) {
        if (id == null) {
            throw new NullPointerException("The id of a DescriptorRegistry cannot be null.");
        }
        this.id = id;
    }

    public static void add(DescriptorRegistry registry) {
        DescriptorRegistryId otherLocal;
        if (REGISTRIES.containsKey(registry.id)) {
            throw new IllegalStateException(String.format("There is a DescriptorRegistry booted with id [%s]", registry.id));
        }
        if (registry.isLocal() && (otherLocal = DescriptorRegistry.lookupLocalRegistry()) != null) {
            throw new IllegalStateException(String.format("Tried to load another local DescriptorRegistry under [%s], already present under [%s]", registry.id, otherLocal));
        }
        REGISTRIES.put(registry.id, registry);
    }

    private static DescriptorRegistryId lookupLocalRegistry() {
        for (DescriptorRegistry descriptorRegistry : REGISTRIES.values()) {
            if (!descriptorRegistry.isLocal()) continue;
            return descriptorRegistry.id;
        }
        return null;
    }

    public static void remove(DescriptorRegistryId id) {
        REGISTRIES.remove(id);
    }

    public static Collection<Descriptor> getDescriptors() {
        return DescriptorRegistry.getDefaultDescriptorRegistry()._getDescriptors();
    }

    static DescriptorRegistry getDefaultDescriptorRegistry() {
        if (REGISTRIES.keySet().isEmpty()) {
            throw new IllegalStateException("No DescriptorRegistries have been loaded.");
        }
        DescriptorRegistryId defaultRegistryId = DescriptorRegistry.lookupLocalRegistry();
        if (defaultRegistryId != null) {
            return DescriptorRegistry.getDescriptorRegistry(defaultRegistryId);
        }
        return REGISTRIES.values().iterator().next();
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return DescriptorRegistry.getDescriptorRegistry(supertype)._getSubtypes(supertype);
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefix, name));
    }

    public static Descriptor getDescriptor(Type type) {
        return DescriptorRegistry.getDescriptorRegistry(type)._getDescriptor(type);
    }

    private static DescriptorRegistry getDescriptorRegistry(Type type) {
        if (type.getTypeSource() == null) {
            throw new NullPointerException(String.format("The type [%s] is not registered with any DescriptorRegistry", type));
        }
        return REGISTRIES.get(type.getTypeSource());
    }

    public static boolean exists(Type type) {
        return DescriptorRegistry.getDescriptorRegistry(type)._exists(type);
    }

    protected static DescriptorRegistry getInstance() {
        return DescriptorRegistry.getDefaultDescriptorRegistry();
    }

    public static DescriptorRegistry getDescriptorRegistry(DescriptorRegistryId id) {
        return REGISTRIES.get(id);
    }

    public Type lookupType(Class<?> ciClass) {
        if (ciClass == null) {
            throw new NullPointerException("Type name may not be null");
        }
        if (this.CLASS_TYPE_CACHE.containsKey(ciClass)) {
            return this.CLASS_TYPE_CACHE.get(ciClass);
        }
        Package ciPackage = ciClass.getPackage();
        Prefix prefix = ciPackage.getAnnotation(Prefix.class);
        if (prefix == null) {
            throw new NullPointerException(String.format("Package [%s] should have an @Prefix annotation for ci-class [%s]", ciPackage.getName(), ciClass.getName()));
        }
        String simpleName = ciClass.getSimpleName();
        if (simpleName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not get a typename for ci-class [%s]", ciClass.getName()));
        }
        Type type = this.lookupType(prefix.value(), simpleName);
        this.CLASS_TYPE_CACHE.put(ciClass, type);
        return type;
    }

    public Type lookupType(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("Type name may not be null");
        }
        if (this.NAME_TYPE_CACHE.containsKey(typeName)) {
            return this.NAME_TYPE_CACHE.get(typeName);
        }
        if (typeName.indexOf(46) == -1) {
            throw new IllegalArgumentException(String.format("Type %s does not contain a prefix", typeName));
        }
        int indexOfLastDot = typeName.lastIndexOf(46);
        Type t = this.lookupType(typeName.substring(0, indexOfLastDot), typeName.substring(indexOfLastDot + 1));
        this.NAME_TYPE_CACHE.put(typeName, t);
        return t;
    }

    public Type lookupType(String prefix, String simpleName) {
        return new Type(prefix, simpleName, this.id);
    }

    protected abstract boolean isLocal();

    protected abstract Collection<Descriptor> _getDescriptors();

    protected abstract Collection<Type> _getSubtypes(Type var1);

    protected abstract Descriptor _getDescriptor(Type var1);

    protected abstract boolean _exists(Type var1);
}

