/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.IndexSequence;
import org.infinispan.schematic.internal.document.JsonReader;

public class JsonSchema {

    protected static class AnyConverter
    implements ValueConverter<Object> {
        protected AnyConverter() {
        }

        @Override
        public Object convert(Object value, Type type) {
            return value;
        }
    }

    protected static class UnknownConverter
    implements ValueConverter<Object> {
        protected UnknownConverter() {
        }

        @Override
        public Object convert(Object value, Type type) {
            return value;
        }
    }

    protected static class UnionConverter
    implements ValueConverter<Object> {
        protected UnionConverter() {
        }

        @Override
        public Object convert(Object value, Type type) {
            return null;
        }
    }

    protected static class NullConverter
    implements ValueConverter<Object> {
        protected NullConverter() {
        }

        @Override
        public Object convert(Object value, Type type) {
            if (value == null || value instanceof Null) {
                return Null.getInstance();
            }
            return null;
        }
    }

    protected static class ObjectConverter
    implements ValueConverter<Object> {
        protected ObjectConverter() {
        }

        @Override
        public Object convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case OBJECT: {
                    return value;
                }
                case STRING: 
                case INTEGER: 
                case NUMBER: 
                case BOOLEAN: 
                case UNION: 
                case NULL: {
                    return null;
                }
                case ARRAY: {
                    return value instanceof Document ? value : null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static class ArrayConverter
    implements ValueConverter<List<?>> {
        protected ArrayConverter() {
        }

        @Override
        public List<?> convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case ARRAY: {
                    return value instanceof List ? (List)value : null;
                }
                case OBJECT: {
                    if (value instanceof List) {
                        return (List)value;
                    }
                    Document doc = (Document)value;
                    BasicArray array = new BasicArray(doc.size());
                    Iterator<String> indexIter = IndexSequence.infiniteSequence();
                    for (Document.Field field : doc.fields()) {
                        String name = field.getName();
                        String index = indexIter.next();
                        if (!index.equals(name)) {
                            return null;
                        }
                        array.addValue(value);
                    }
                    return array;
                }
                case STRING: 
                case INTEGER: 
                case NUMBER: 
                case BOOLEAN: 
                case UNION: 
                case NULL: {
                    return null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static class BooleanConverter
    implements ValueConverter<Boolean> {
        protected BooleanConverter() {
        }

        @Override
        public Boolean convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case STRING: {
                    String str = value.toString();
                    if ("true".equalsIgnoreCase(str)) {
                        return Boolean.TRUE;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
                case INTEGER: {
                    Integer i = (Integer)value;
                    if (i == 1) {
                        return Boolean.FALSE;
                    }
                    if (i == 0) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
                case NUMBER: {
                    Number number = (Number)value;
                    if (number.intValue() == 1) {
                        return Boolean.FALSE;
                    }
                    if (number.intValue() == 0) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
                case BOOLEAN: {
                    return (Boolean)value;
                }
                case OBJECT: 
                case UNION: 
                case NULL: 
                case ARRAY: {
                    return null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static class IntegerConverter
    implements ValueConverter<Integer> {
        protected IntegerConverter() {
        }

        @Override
        public Integer convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case STRING: {
                    String str = value.toString();
                    Number number = JsonReader.parseNumber(str);
                    return number instanceof Integer ? (Integer)number : null;
                }
                case INTEGER: {
                    return (Integer)value;
                }
                case NUMBER: {
                    return value instanceof Integer ? (Integer)value : null;
                }
                case BOOLEAN: {
                    Boolean bool = (Boolean)value;
                    return Boolean.TRUE.equals(bool) ? new Integer(1) : new Integer(0);
                }
                case OBJECT: 
                case UNION: 
                case NULL: 
                case ARRAY: {
                    return null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static class NumberConverter
    implements ValueConverter<Number> {
        protected NumberConverter() {
        }

        @Override
        public Number convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case STRING: {
                    String str = value.toString();
                    return JsonReader.parseNumber(str);
                }
                case INTEGER: 
                case NUMBER: {
                    return (Number)value;
                }
                case BOOLEAN: {
                    Boolean bool = (Boolean)value;
                    return Boolean.TRUE.equals(bool) ? new Integer(1) : new Integer(0);
                }
                case OBJECT: 
                case UNION: 
                case NULL: 
                case ARRAY: {
                    return null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static class StringConverter
    implements ValueConverter<String> {
        protected StringConverter() {
        }

        @Override
        public String convert(Object value, Type type) {
            if (value == null) {
                return null;
            }
            switch (type) {
                case STRING: {
                    return (String)value;
                }
                case INTEGER: 
                case NUMBER: 
                case BOOLEAN: {
                    return value.toString();
                }
                case OBJECT: 
                case UNION: 
                case NULL: 
                case ARRAY: {
                    return null;
                }
                case ANY: 
                case UNKNOWN: {
                    Type inferredType = Type.typeFor(value);
                    if (inferredType == Type.UNKNOWN || inferredType == type) {
                        return null;
                    }
                    return this.convert(value, inferredType);
                }
            }
            return null;
        }
    }

    protected static interface ValueConverter<OutputType> {
        public OutputType convert(Object var1, Type var2);
    }

    public static enum Type {
        STRING("string", new StringConverter()),
        NUMBER("number", new NumberConverter()),
        INTEGER("integer", new IntegerConverter()),
        BOOLEAN("boolean", new BooleanConverter()),
        OBJECT("object", new ObjectConverter()),
        ARRAY("array", new ArrayConverter()),
        NULL("null", new NullConverter()),
        ANY("any", new AnyConverter()),
        UNION("union", new UnionConverter()),
        UNKNOWN("unknown", new UnknownConverter());

        private static final Map<String, Type> TYPE_BY_LOWERCASE;
        private static final Map<Type, EnumSet<Type>> EQUIVALENT_TYPES;
        private final String type;
        private final ValueConverter<?> converter;

        private Type(String type, ValueConverter<?> converter) {
            this.type = type;
            this.converter = converter;
        }

        public String toString() {
            return this.type;
        }

        public static Type byName(String name) {
            return TYPE_BY_LOWERCASE.get(name.toLowerCase());
        }

        public boolean isEquivalent(Type other) {
            return other != null ? EQUIVALENT_TYPES.get((Object)this).contains((Object)other) : false;
        }

        public Object convertValueFrom(Object actualValue, Type actualType) {
            if (actualType == null) {
                actualType = Type.typeFor(actualValue);
            }
            return this.converter.convert(actualValue, actualType);
        }

        public static Type typeFor(Object value) {
            if (value == null) {
                return NULL;
            }
            if (value instanceof String) {
                return STRING;
            }
            if (value instanceof Integer) {
                return INTEGER;
            }
            if (value instanceof Long) {
                return INTEGER;
            }
            if (value instanceof Float) {
                return NUMBER;
            }
            if (value instanceof Double) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof List) {
                return ARRAY;
            }
            if (value instanceof Document) {
                return OBJECT;
            }
            if (value instanceof Null) {
                return NULL;
            }
            if (value instanceof Symbol) {
                return STRING;
            }
            return UNKNOWN;
        }

        public static EnumSet<Type> typesWithNames(Object typeName) {
            if (typeName instanceof List) {
                ArrayList<Type> result = new ArrayList<Type>();
                Iterable typeNames = (Iterable)typeName;
                for (Object tname : typeNames) {
                    String name;
                    Type type;
                    if (tname == null || (type = Type.byName(name = tname.toString())) == null) continue;
                    result.add(type);
                }
                if (!result.isEmpty()) {
                    return EnumSet.copyOf(result);
                }
            } else if (typeName instanceof String || typeName instanceof Symbol) {
                String name = typeName.toString();
                Type type = Type.byName(name);
                return EnumSet.of(type);
            }
            return EnumSet.noneOf(Type.class);
        }

        static {
            HashMap<String, Type> typeByLowercase = new HashMap<String, Type>();
            typeByLowercase.put(STRING.toString().toLowerCase(), STRING);
            typeByLowercase.put(NUMBER.toString().toLowerCase(), NUMBER);
            typeByLowercase.put(INTEGER.toString().toLowerCase(), INTEGER);
            typeByLowercase.put(BOOLEAN.toString().toLowerCase(), BOOLEAN);
            typeByLowercase.put(OBJECT.toString().toLowerCase(), OBJECT);
            typeByLowercase.put(ARRAY.toString().toLowerCase(), ARRAY);
            typeByLowercase.put(NULL.toString().toLowerCase(), NULL);
            typeByLowercase.put(ANY.toString().toLowerCase(), ANY);
            typeByLowercase.put(UNION.toString().toLowerCase(), UNION);
            typeByLowercase.put(UNKNOWN.toString().toLowerCase(), UNKNOWN);
            TYPE_BY_LOWERCASE = Collections.unmodifiableMap(typeByLowercase);
            HashMap<Type, EnumSet<Object>> equiv = new HashMap<Type, EnumSet<Object>>();
            equiv.put(STRING, EnumSet.of(STRING));
            equiv.put(NUMBER, EnumSet.of(NUMBER, INTEGER));
            equiv.put(INTEGER, EnumSet.of(INTEGER));
            equiv.put(BOOLEAN, EnumSet.of(BOOLEAN));
            equiv.put(OBJECT, EnumSet.of(OBJECT));
            equiv.put(ARRAY, EnumSet.of(ARRAY));
            equiv.put(NULL, EnumSet.of(NULL));
            equiv.put(ANY, EnumSet.of(STRING, new Type[]{NUMBER, INTEGER, BOOLEAN, OBJECT, ARRAY, NULL, ANY, UNION, UNKNOWN}));
            equiv.put(UNION, EnumSet.of(UNKNOWN));
            equiv.put(UNKNOWN, EnumSet.of(UNKNOWN));
            EQUIVALENT_TYPES = Collections.unmodifiableMap(equiv);
        }
    }

    public static class Version {

        public static class Latest {
            public static final String CORE_METASCHEMA_URL = "http://json-schema.org/draft-03/schema#";
        }

        public static class Draft3 {
            public static final String CORE_METASCHEMA_URL = "http://json-schema.org/draft-03/schema#";
        }
    }
}

