from parser.performance import performance_test_result_parser
from parser.xunit import open_file
from com.xebialabs.xlt.plugin.api.resultparser.performance import SamplingPerformanceResultsSummary
from xml.etree import ElementTree as ET

def get_root_node(file):
    """
    This function returns just the root node, no child nodes.

    :param file: `java.io.File` to read.
    :return: a bare ElementTree node with just the root node.
    """
    with open_file(file) as f:
        event, rootNode = ET.iterparse(f, events=('start',)).next()
        return rootNode


class JMeterXmlParser(object):
    start_time = None

    def filter_readable(self, files):
        result = []
        for file in files:
            if str(file).endswith("xml"):
                root = get_root_node(file)
                if root.tag.endswith("testResults"):
                    result.append(file)
        return result

    def construct_performance_results_summary(self, file):
        result = SamplingPerformanceResultsSummary()
        with open_file(file) as f:
            for event, elem in ET.iterparse(f):
                if elem.tag == 'httpSample':
                    timestamp = int(elem.attrib['ts'])
                    elapsed = int(elem.attrib['t'])
                    testResult = elem.attrib['s']
                    result.updateWithSample(timestamp, elapsed, testResult)
                    elem.clear()

        return result

    def enrich_import_started_event(self, importStartedEvent):
        pass


result_holder.result = performance_test_result_parser(files, test_run_historian=test_run_historian, parser=JMeterXmlParser())


# Taken from JMeter documentation: http://jmeter.apache.org/usermanual/listeners.html (14.7)
#
# The sample attributes have the following meaning:
#
# Attribute	Content
# by	Bytes
# de	Data encoding
# dt	Data type
# ec	Error count (0 or 1, unless multiple samples are aggregated)
# hn	Hostname where the sample was generated
# it	Idle Time = time not spent sampling (milliseconds) (generally 0)
# lb	Label
# lt	Latency = time to initial response (milliseconds) - not all samplers support this
# na	Number of active threads for all thread groups
# ng	Number of active threads in this group
# rc	Response Code (e.g. 200)
# rm	Response Message (e.g. OK)
# s	Success flag (true/false)
# sc	Sample count (1, unless multiple samples are aggregated)
# t	Elapsed time (milliseconds)
# tn	Thread Name
# ts	timeStamp (milliseconds since midnight Jan 1, 1970 UTC)
# varname	Value of the named variable (versions of JMeter after 2.3.1)
