# NOTE: Please do not edit this file directly
# Create your custom reports in the 'ext' folder

from modules.hierarchy import *

prefixParam = get_prefix_param(query_parameters)
prefixArray = get_prefix_array(query_parameters)

prefix = ''

level = len(prefixArray)

paramDate = query_parameters.get('date')
paramRange = query_parameters.get('range')

events = test_runs.getEventsForTestRun(test_run, {'@tags': tags})

passed = 0
other = 0
failed = 0
for event in events:
    if is_functional_result(event) and prefix_within_hierarchy(event, prefixArray):
        result = event.getResult()
        if result is None:
            continue

        if result == 'PASSED':
            passed = passed + 1
        elif result == 'OTHER':
            other = other + 1
        else:
            failed = failed + 1

        if prefix == '':
            prefix = get_prefix_from_hierarchy(event, level + 1)


result_holder.result = {
        'chart': {
            'type': 'pie',
            'plotBackgroundColor': None,
            'plotBorderWidth': None,
            'plotShadow': False
        },
        'title': 'Passed versus failed tests from latest test run in time window',
        'description': 'This report presents the number of tests that passed and failed during the last execution of the test specification.',
        'tooltip': {
           'enabled': False
        },
        'legend': {
            'borderColor': None,
            'layout': 'vertical',
            'verticalAlign': 'middle',
            'symbolHeight': 12,
            'symbolWidth': 12,
            'symbolRadius': 6,
            'itemMarginBottom': 4
        },
        'plotOptions': {
            'series': {
                'slicedOffset': 0,
                'point': {
                    'events': {
                        'click': 'url'
                    }
                }
            },
            'pie': {
                'allowPointSelect': True,
                'dataLabels': {
                    'enabled': True,
                    'distance': -15,
                    'format': '{y}'
                },
                'innerSize': '70%',
                'showInLegend': 'True',
                'animation': False,
                'states': {
                    'hover': {
                        'enabled': False
                    }
                }
            }
        },
        'series': [{
            'data': [{
                    'name': "Passed ({0})".format(passed),
                    'y': passed
                },
                {
                    'name': "Failed ({0})".format(failed),
                    'y': failed
                },
                {
                    'name': "Other ({0})".format(other),
                    'y': other
                }
            ]
        }]
    }
