@echo off
REM
REM Batch script to uninstall XL TestView Server service
REM

setlocal ENABLEDELAYEDEXPANSION

REM Get XL TestView server home dir
if "%xlt_home%"=="" (
    cd /d "%~dp0"
    cd ..
    set xlt_home=!CD!
)

rem Checking for administrative permissions
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo This script must be run as administrator to work properly!
    REM exit /b %errorLevel%
    exit %errorLevel%
)

REM default wrapper home
set wrapper_home=%xlt_home%\service\yajsw

REM default java exe for running the wrapper
if "%JAVA_HOME%"=="" (
  set java_exe=java.exe
) else (
  set java_exe="%JAVA_HOME%\bin\java.exe"
)

REM location of the wrapper jar file. necessary lib files will be loaded by this jar. they must be at <wrapper_home>/lib/...
set wrapper_jar="%wrapper_home%/wrapper.jar"

rem setting java options for wrapper process. depending on the scripts used, the wrapper may require more memory.
set wrapper_java_options=-Xmx30m -Djna_tmpdir="%wrapper_home%/tmp" -Djava.net.preferIPv4Stack=true

rem configuration file used by all bat files
set conf_file="%xlt_home%/conf/xlt-wrapper.conf"

set user=""

call %java_exe% %wrapper_java_options% -jar %wrapper_jar% -p -r %conf_file%

endlocal
