/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.Imploder;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.ItemConflictException;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.security.Permissions2;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.artifact.resolution.jcr.JcrArtifactResolver;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeWriter {
    private final Session session;
    private final ConfigurationItem item;
    private final Node node;
    private final PasswordEncrypter passwordEncrypter;
    private boolean basicsWritten = false;
    private static final Logger logger = LoggerFactory.getLogger(NodeWriter.class);

    NodeWriter(Session session, ConfigurationItem item, Node node, PasswordEncrypter passwordEncrypter) {
        this.session = (Session)Preconditions.checkNotNull((Object)session);
        this.item = (ConfigurationItem)Preconditions.checkNotNull((Object)item);
        this.node = (Node)Preconditions.checkNotNull((Object)node);
        this.passwordEncrypter = (PasswordEncrypter)Preconditions.checkNotNull((Object)passwordEncrypter);
    }

    void writeBasics() throws RepositoryException {
        this.node.setProperty("$configuration.item.type", this.item.getType().toString());
        if (this.item instanceof BaseConfigurationItem) {
            String token = ((BaseConfigurationItem)this.item).get$token();
            if (com.google.common.base.Strings.isNullOrEmpty((String)token) || this.node.hasProperty("$token") && this.node.getProperty("$token").getString().equals(token)) {
                String newToken = UUID.randomUUID().toString();
                this.node.setProperty("$token", newToken);
                ((BaseConfigurationItem)this.item).set$token(newToken);
            } else {
                throw new ItemConflictException("Repository entity [%s] has been updated since you read it. Please reload the CI from the repository again.", new Object[]{this.item.getId()});
            }
        }
        this.basicsWritten = true;
    }

    void write() throws RepositoryException {
        if (!this.basicsWritten) {
            this.writeBasics();
        }
        this.setMixinsCorrect();
        this.copyData();
        this.copyValuesIntoNode();
        this.copyMetadata();
        this.updateParentForListAsContainmentRelation();
    }

    private void setMixinsCorrect() throws RepositoryException {
        if (this.item.getType().getDescriptor().isVersioned()) {
            if (this.node.canAddMixin("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                this.node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
            }
        } else if (this.node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
            this.node.removeMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }
    }

    private void copyData() throws RepositoryException {
        if (this.item instanceof SourceArtifact) {
            SourceArtifact artifact = (SourceArtifact)this.item;
            OverthereFile file = ((Artifact)this.item).getFile();
            String fileUri = artifact.getFileUri();
            if (file != null && (fileUri == null || JcrArtifactResolver.canHandle(fileUri))) {
                MessageDigest sha1 = JavaCryptoUtils.getSha1();
                this.setPropertiesForRegularFileUpload(sha1, file);
            } else if (!this.node.hasProperty("$filename")) {
                this.setPropertiesForExternalArtifact(file);
                artifact.setFile(null);
            } else {
                this.setPropertyFromNode("checksum");
                this.setPropertyFromNode("fileUri");
            }
        }
    }

    private void setPropertiesForExternalArtifact(OverthereFile file) throws RepositoryException {
        this.node.setProperty("$filename", file.getName());
    }

    private void setPropertiesForRegularFileUpload(MessageDigest sha1, OverthereFile file) throws RepositoryException {
        String fileUri;
        InputStream dataInput;
        this.node.setProperty("$filename", file.getName());
        if (this.item instanceof FolderArtifact) {
            if (file.isDirectory()) {
                try {
                    ByteSource implode = Imploder.implode((OverthereFile)file, (MessageDigest)sha1);
                    dataInput = implode.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not zip up the data in file " + file, (Throwable)e);
                }
            }
            try {
                Exploder.calculateCheckSum((ByteSource)this.newInputStreamSupplier(file), (MessageDigest)sha1);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Could not calculate checksum for zipped Folder artifact.", (Throwable)e);
            }
            dataInput = file.getInputStream();
        } else {
            dataInput = new DigestInputStream(file.getInputStream(), sha1);
        }
        this.writeBinaryData(dataInput);
        if (this.isChecksumBlank()) {
            this.item.setProperty("checksum", (Object)JavaCryptoUtils.digest((MessageDigest)sha1));
        }
        try {
            fileUri = JcrArtifactResolver.Protocol() + ":" + URLEncoder.encode(file.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException("Could not encode the file name.", (Throwable)e);
        }
        this.item.setProperty("fileUri", (Object)fileUri);
    }

    private boolean isChecksumBlank() {
        return this.item.hasProperty("checksum") && Strings.isBlank((String)((String)this.item.getProperty("checksum")));
    }

    private void setPropertyFromNode(String propertyName) throws RepositoryException {
        if (this.item.hasProperty(propertyName) && Strings.isBlank((String)((String)this.item.getProperty(propertyName)))) {
            this.item.setProperty(propertyName, (Object)this.node.getProperty(propertyName).getString());
        }
    }

    private ByteSource newInputStreamSupplier(OverthereFile file) {
        return this.newInputStreamSupplier(file.getInputStream());
    }

    private ByteSource newInputStreamSupplier(final InputStream is) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return is;
            }
        };
    }

    private void writeBinaryData(InputStream dataInput) throws RepositoryException {
        try {
            Binary binary = this.session.getValueFactory().createBinary(dataInput);
            this.node.setProperty("$data", binary);
        }
        finally {
            Closeables.closeQuietly((Closeable)dataInput);
        }
    }

    private void copyValuesIntoNode() throws RepositoryException {
        Descriptor ciDescriptor = DescriptorRegistry.getDescriptor((Type)this.item.getType());
        Collection propertyDescriptors = Collections2.filter((Collection)ciDescriptor.getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.isTransient();
            }
        });
        block10: for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.get(this.item) == null) {
                this.removePropertyFromNode(pd);
                continue;
            }
            logger.trace("Writing property [{}] with value [{}]", (Object)pd.getFqn(), pd.isPassword() ? "********" : pd.get(this.item));
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.copyPrimitivePropertyIntoNode(pd);
                    continue block10;
                }
                case DATE: {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    cal.setTime((Date)pd.get(this.item));
                    this.node.setProperty(pd.getName(), this.session.getValueFactory().createValue((Calendar)cal));
                    continue block10;
                }
                case SET_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block10;
                }
                case SET_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block10;
                }
                case LIST_OF_STRING: {
                    this.copyCollectionOfStringsPropertyIntoNode(pd);
                    continue block10;
                }
                case LIST_OF_CI: {
                    this.copyCollectionOfConfigurationItemsPropertyIntoNode(pd);
                    continue block10;
                }
                case CI: {
                    this.copyConfigurationItemPropertyIntoNode(pd);
                    continue block10;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyIntoNode(pd);
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Cannot convert property " + pd.getName() + " because it is of unsupported kind " + pd.getKind());
        }
    }

    private void copyMapPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        MapStringStringView value = MapStringStringView.from((Map)((Map)pd.get(this.item)));
        if (pd.isPassword()) {
            value = value.encrypt();
        }
        Map toWrite = Maps.transformValues((Map)value.getWrapped(), (Function)StringValueConverter.valueToString((PasswordEncrypter)this.passwordEncrypter));
        JcrUtils.writeMap(this.node, pd.getName(), toWrite);
    }

    private void copyMetadata() throws RepositoryException {
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        this.setCreatedByMetadata();
        this.setCreatedAtMetadata(now);
        this.setLastModifiedByMetadata();
        this.setLastModifiedAtMetadata(now);
        if (this.item instanceof BaseConfigurationItem) {
            ((BaseConfigurationItem)this.item).set$ciAttributes(NodeUtils.readCiAttributes(this.node));
        }
    }

    private Calendar toCal(DateTime dt) {
        Calendar utc = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        utc.setTimeInMillis(dt.getMillis());
        return utc;
    }

    private void setLastModifiedAtMetadata(DateTime now) throws RepositoryException {
        this.node.setProperty("$lastModified", this.toCal(now));
    }

    private void setLastModifiedByMetadata() throws RepositoryException {
        this.node.setProperty("$creatingUser", Permissions2.getAuthenticatedUserName());
    }

    private void setCreatedByMetadata() throws RepositoryException {
        if (!this.node.hasProperty("$createdBy")) {
            String username = Permissions2.getAuthenticatedUserName();
            if (this.node.hasProperty("$creatingUser")) {
                username = this.node.getProperty("$creatingUser").getString();
            }
            this.node.setProperty("$createdBy", username);
        }
    }

    private void setCreatedAtMetadata(DateTime now) throws RepositoryException {
        if (!this.node.hasProperty("$createdAt")) {
            Calendar when = this.toCal(now);
            if (this.node.hasProperty("$lastModified")) {
                when = this.node.getProperty("$lastModified").getDate();
            }
            this.node.setProperty("$createdAt", when);
        }
    }

    private void removePropertyFromNode(PropertyDescriptor pd) throws RepositoryException {
        try {
            this.node.getProperty(pd.getName()).remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void copyPrimitivePropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = pd.get(this.item).toString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = this.passwordEncrypter.ensureEncrypted(valueAsString);
        }
        this.node.setProperty(pd.getName(), valueAsString);
    }

    private void copyCollectionOfStringsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        Property property;
        ValueFactory valueFactory = this.session.getValueFactory();
        StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);
        SetOfStringView valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        ArrayList jcrValueList = Lists.newArrayList();
        if (!(valueAsCollection instanceof AbstractStringView)) {
            valueAsCollection = valueAsCollection instanceof Set ? SetOfStringView.from((Set)((Set)valueAsCollection)) : ListOfStringView.from((List)((List)valueAsCollection));
        }
        AbstractStringView view = (AbstractStringView)valueAsCollection;
        if (pd.isPassword()) {
            view = view.encrypt();
        }
        for (Object o : view.getWrapped()) {
            if (!(o instanceof StringValue)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of configuration item " + this.item.getId() + " is not a StringValue: " + o);
            }
            StringValue stringValue = (StringValue)o;
            jcrValueList.add(valueFactory.createValue(converter.convert(stringValue)));
        }
        Value[] jcrValues = jcrValueList.toArray(new Value[jcrValueList.size()]);
        if (this.node.hasProperty(pd.getName()) && (!(property = this.node.getProperty(pd.getName())).isMultiple() || jcrValues.length == 0)) {
            property.remove();
        }
        if (jcrValues.length > 0) {
            this.node.setProperty(pd.getName(), jcrValues);
        }
    }

    private void copyConfigurationItemPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment()) {
            return;
        }
        String referencedCiId = ((ConfigurationItem)pd.get(this.item)).getId();
        Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
        this.node.setProperty(pd.getName(), referencedCi);
    }

    private void copyCollectionOfConfigurationItemsPropertyIntoNode(PropertyDescriptor pd) throws RepositoryException {
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.SET_OF_CI) {
            return;
        }
        Collection<?> valueAsCollection = this.convertObjectValueToCollection(pd, pd.get(this.item));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        ArrayList jcrReferenceList = Lists.newArrayList();
        for (Object each : valueAsCollection) {
            if (!(each instanceof ConfigurationItem)) {
                throw new IllegalArgumentException("Element in property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a ConfigurationItem: " + each);
            }
            String referencedCiId = ((ConfigurationItem)each).getId();
            set.add(referencedCiId);
            Node referencedCi = this.session.getNode(JcrPathHelper.getAbsolutePathFromId(referencedCiId));
            if (pd.isAsContainment() && !referencedCi.getParent().getPath().equals(JcrPathHelper.getAbsolutePathFromId(this.item.getId()))) {
                throw new Checks.IncorrectArgumentException("Cannot add [%s] to property [%s] of item [%s], as it is not contained by it.", new Object[]{referencedCiId, pd.getName(), this.item.getId()});
            }
            jcrReferenceList.add(this.session.getValueFactory().createValue(referencedCi));
        }
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.LIST_OF_CI) {
            Map<String, Node> referencesFromProperty = this.getReferencesFromProperty(this.node, pd.getName());
            for (String s : referencesFromProperty.keySet()) {
                if (!set.add(JcrPathHelper.getIdFromAbsolutePath(s))) continue;
                jcrReferenceList.add(this.session.getValueFactory().createValue(referencesFromProperty.get(s)));
            }
        }
        Value[] jcrReferenceValues = jcrReferenceList.toArray(new Value[jcrReferenceList.size()]);
        if (this.node.hasProperty(pd.getName())) {
            this.node.getProperty(pd.getName()).remove();
        }
        if (jcrReferenceValues.length > 0) {
            this.node.setProperty(pd.getName(), jcrReferenceValues, 9);
        }
    }

    private Collection<?> convertObjectValueToCollection(PropertyDescriptor pd, Object value) {
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("Property " + pd.getName() + " of repository entity " + this.item.getId() + " is not a Collection: " + value);
        }
        return (Collection)value;
    }

    private void updateParentForListAsContainmentRelation() throws RepositoryException {
        Node parent = this.node.getParent();
        if (parent.getPath().equals(this.session.getRootNode().getPath())) {
            return;
        }
        Type parentType = NodeUtils.typeOf(parent);
        PropertyDescriptor pd = NodeUtils.findContainmentListProperty(parentType, this.item.getType());
        if (pd == null) {
            return;
        }
        String referencingPropertyName = pd.getName();
        Map<String, Node> nodes = this.getReferencesFromProperty(parent, referencingPropertyName);
        nodes.put(this.node.getPath(), this.node);
        ArrayList values = Lists.newArrayList();
        for (Node n : nodes.values()) {
            values.add(this.session.getValueFactory().createValue(n));
        }
        parent.setProperty(referencingPropertyName, values.toArray(new Value[values.size()]), 9);
    }

    private Map<String, Node> getReferencesFromProperty(Node node, String propertyName) throws RepositoryException {
        LinkedHashMap nodes = Maps.newLinkedHashMap();
        if (node.hasProperty(propertyName)) {
            Property referencingProperty = node.getProperty(propertyName);
            for (Value value : referencingProperty.getValues()) {
                Node referencedCiNode = NodeUtils.getReferencedCiNode(node, value, this.session);
                nodes.put(referencedCiNode.getPath(), referencedCiNode);
            }
        }
        return nodes;
    }
}

