/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.validation;

import java.util.List;
import java.util.ListIterator;
import org.apache.commons.cli2.resource.ResourceHelper;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;

public class ClassValidator
implements Validator {
    private static final ResourceHelper resources = ResourceHelper.getResourceHelper();
    private boolean loadable;
    private boolean instance;
    private ClassLoader loader;

    public void validate(List values) throws InvalidArgumentException {
        ListIterator<Object> i = values.listIterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!this.isPotentialClassName(name)) {
                throw new InvalidArgumentException(resources.getMessage("ClassValidator.bad.classname", name));
            }
            if (!this.loadable && !this.instance) continue;
            ClassLoader theLoader = this.getClassLoader();
            try {
                Class<?> clazz = theLoader.loadClass(name);
                if (this.instance) {
                    i.set(clazz.newInstance());
                    continue;
                }
                i.set(clazz);
            }
            catch (ClassNotFoundException exp) {
                throw new InvalidArgumentException(resources.getMessage("ClassValidator.class.notfound", name));
            }
            catch (IllegalAccessException exp) {
                throw new InvalidArgumentException(resources.getMessage("ClassValidator.class.access", name, exp.getMessage()));
            }
            catch (InstantiationException exp) {
                throw new InvalidArgumentException(resources.getMessage("ClassValidator.class.create", name));
            }
        }
    }

    public boolean isLoadable() {
        return this.loadable;
    }

    public void setLoadable(boolean loadable) {
        this.loadable = loadable;
    }

    public ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.getClass().getClassLoader();
        }
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public boolean isInstance() {
        return this.instance;
    }

    public void setInstance(boolean instance) {
        this.instance = instance;
    }

    protected boolean isPotentialClassName(String name) {
        char[] chars = name.toCharArray();
        boolean expectingStart = true;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (expectingStart) {
                if (!Character.isJavaIdentifierStart(c)) {
                    return false;
                }
                expectingStart = false;
            } else if (c == '.') {
                expectingStart = true;
            } else if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++i;
        }
        return !expectingStart;
    }
}

