/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.validation.ClassValidator;
import org.apache.commons.cli2.validation.DateValidator;
import org.apache.commons.cli2.validation.FileValidator;
import org.apache.commons.cli2.validation.NumberValidator;
import org.apache.commons.cli2.validation.UrlValidator;
import org.apache.commons.cli2.validation.Validator;

public class PatternBuilder {
    private final GroupBuilder gbuilder;
    private final DefaultOptionBuilder obuilder;
    private final ArgumentBuilder abuilder;
    private final Set options = new LinkedHashSet();

    public PatternBuilder() {
        this(new GroupBuilder(), new DefaultOptionBuilder(), new ArgumentBuilder());
    }

    public PatternBuilder(GroupBuilder gbuilder, DefaultOptionBuilder obuilder, ArgumentBuilder abuilder) {
        this.gbuilder = gbuilder;
        this.obuilder = obuilder;
        this.abuilder = abuilder;
    }

    public Option create() {
        Option option;
        if (this.options.size() == 1) {
            option = (Option)this.options.iterator().next();
        } else {
            this.gbuilder.reset();
            Iterator i = this.options.iterator();
            while (i.hasNext()) {
                this.gbuilder.withOption((Option)i.next());
            }
            option = this.gbuilder.create();
        }
        this.reset();
        return option;
    }

    public PatternBuilder reset() {
        this.options.clear();
        return this;
    }

    private void createOption(char type, boolean required, char opt) {
        Argument argument;
        if (type != ' ') {
            this.abuilder.reset();
            this.abuilder.withValidator(PatternBuilder.validator(type));
            if (required) {
                this.abuilder.withMinimum(1);
            }
            if (type != '*') {
                this.abuilder.withMaximum(1);
            }
            argument = this.abuilder.create();
        } else {
            argument = null;
        }
        this.obuilder.reset();
        this.obuilder.withArgument(argument);
        this.obuilder.withShortName(String.valueOf(opt));
        this.obuilder.withRequired(required);
        this.options.add(this.obuilder.create());
    }

    public void withPattern(String pattern) {
        int sz = pattern.length();
        int opt = 32;
        int ch = 32;
        int type = 32;
        boolean required = false;
        int i = 0;
        while (i < sz) {
            ch = pattern.charAt(i);
            switch (ch) {
                case 33: {
                    required = true;
                    break;
                }
                case 35: 
                case 37: 
                case 42: 
                case 43: 
                case 47: 
                case 58: 
                case 60: 
                case 62: 
                case 64: {
                    type = ch;
                    break;
                }
                default: {
                    if (opt != 32) {
                        this.createOption((char)type, required, (char)opt);
                        required = false;
                        type = 32;
                    }
                    opt = ch;
                }
            }
            ++i;
        }
        if (opt != 32) {
            this.createOption((char)type, required, (char)opt);
        }
    }

    private static Validator validator(char c) {
        switch (c) {
            case '@': {
                ClassValidator classv = new ClassValidator();
                classv.setInstance(true);
                return classv;
            }
            case '+': {
                ClassValidator instancev = new ClassValidator();
                return instancev;
            }
            case '%': {
                return NumberValidator.getNumberInstance();
            }
            case '#': {
                return DateValidator.getDateInstance();
            }
            case '<': {
                FileValidator existingv = new FileValidator();
                existingv.setExisting(true);
                existingv.setFile(true);
                return existingv;
            }
            case '*': 
            case '>': {
                return new FileValidator();
            }
            case '/': {
                return new UrlValidator();
            }
        }
        return null;
    }
}

