/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.resource.ResourceHelper;

public class DefaultOptionBuilder {
    private final String shortPrefix;
    private final String longPrefix;
    private final boolean burstEnabled;
    private String preferredName;
    private Set aliases;
    private Set burstAliases;
    private boolean required;
    private String description;
    private Argument argument;
    private Group children;
    private int id;

    public DefaultOptionBuilder() {
        this("-", "--", true);
    }

    public DefaultOptionBuilder(String shortPrefix, String longPrefix, boolean burstEnabled) throws IllegalArgumentException {
        if (shortPrefix == null || shortPrefix.length() == 0) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Option.illegal.short.prefix"));
        }
        if (longPrefix == null || longPrefix.length() == 0) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Option.illegal.long.prefix"));
        }
        this.shortPrefix = shortPrefix;
        this.longPrefix = longPrefix;
        this.burstEnabled = burstEnabled;
        this.reset();
    }

    public DefaultOption create() throws IllegalStateException {
        if (this.preferredName == null) {
            throw new IllegalStateException(ResourceHelper.getResourceHelper().getMessage("Option.no.name"));
        }
        DefaultOption option = new DefaultOption(this.shortPrefix, this.longPrefix, this.burstEnabled, this.preferredName, this.description, this.aliases, this.burstAliases, this.required, this.argument, this.children, this.id);
        this.reset();
        return option;
    }

    public DefaultOptionBuilder reset() {
        this.preferredName = null;
        this.description = null;
        this.aliases = new HashSet();
        this.burstAliases = new HashSet();
        this.required = false;
        this.argument = null;
        this.children = null;
        this.id = 0;
        return this;
    }

    public DefaultOptionBuilder withShortName(String shortName) {
        String name = String.valueOf(this.shortPrefix) + shortName;
        if (this.preferredName == null) {
            this.preferredName = name;
        } else {
            this.aliases.add(name);
        }
        if (this.burstEnabled && name.length() == this.shortPrefix.length() + 1) {
            this.burstAliases.add(name);
        }
        return this;
    }

    public DefaultOptionBuilder withLongName(String longName) {
        String name = String.valueOf(this.longPrefix) + longName;
        if (this.preferredName == null) {
            this.preferredName = name;
        } else {
            this.aliases.add(name);
        }
        return this;
    }

    public DefaultOptionBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public DefaultOptionBuilder withRequired(boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public DefaultOptionBuilder withChildren(Group newChildren) {
        this.children = newChildren;
        return this;
    }

    public DefaultOptionBuilder withArgument(Argument newArgument) {
        this.argument = newArgument;
        return this;
    }

    public final DefaultOptionBuilder withId(int newId) {
        this.id = newId;
        return this;
    }
}

