/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.core.rest.resteasy.OpenJcrSessionDuringRequestInterceptor;
import com.xebialabs.deployit.core.rest.resteasy.PathInterceptor;
import com.xebialabs.deployit.core.rest.resteasy.UsernameInjectorPrePostProcessor;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirPrePostProcessorInterceptor;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClosingExceptionMapper<E extends Exception>
implements ExceptionMapper<E> {
    public static final String X_EXCEPTION_TYPE = "X-Exception-Type";
    public static final String X_PATH = "X-Path";
    protected final boolean hideInternals;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ClosingExceptionMapper(boolean hideInternals) {
        this.hideInternals = hideInternals;
    }

    public final Response toResponse(E exception) {
        try {
            Response response = this.handleException(exception);
            return response;
        }
        finally {
            OpenJcrSessionDuringRequestInterceptor.cleanup();
            WorkdirPrePostProcessorInterceptor.cleanup();
            PathInterceptor.PATH.remove();
            UsernameInjectorPrePostProcessor.cleanup();
        }
    }

    protected abstract Response handleException(E var1);

    protected Response checkWhetherWeHideInternals(int status, RuntimeException e, String content) {
        if (status > 499 && this.hideInternals) {
            UUID uuid = UUID.randomUUID();
            this.logger.error("[UUID={}] Encountered statuscode [{}], hiding it with a 400.", (Object)uuid, (Object)status);
            this.logger.error("[UUID={}] Exception: {}", (Object)uuid, (Object)e.getClass().getName());
            this.logger.error("[UUID={}] Error messages: {}", (Object)uuid, (Object)content);
            return Response.status((int)400).type("text/plain").entity((Object)("An internal error has occurred, please notify your system administrator with the following code: " + uuid)).build();
        }
        return null;
    }
}

