/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.upgrade.jcr.v130;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xltest.domain.BaseTestSpecification;
import com.xebialabs.xltest.domain.TestToolNameAware;
import com.xebialabs.xltest.repository.ValidatingRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RenameTestToolInSpecUpgrade
extends Upgrade {
    private static final Logger LOG = LoggerFactory.getLogger(RenameTestToolInSpecUpgrade.class);
    private final Map<String, String> testToolDict = new HashMap<String, String>();
    private final ValidatingRepository repositoryService;

    @Autowired
    public RenameTestToolInSpecUpgrade(ValidatingRepository repositoryService) {
        this.testToolDict.put("Cucumber", "xlt.Cucumber");
        this.testToolDict.put("FitNesse", "xlt.FitNesse");
        this.testToolDict.put("Gatling", "xlt.Gatling");
        this.testToolDict.put("xUnit", "xlt.JUnit");
        this.testToolDict.put("JMeter", "xlt.JMeterCSV");
        this.repositoryService = repositoryService;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"xl-testview", (String)"1.3.0#5");
    }

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        List<BaseTestSpecification> allTestSpecs = this.getAllTestSpecs();
        for (BaseTestSpecification node : allTestSpecs) {
            TestToolNameAware testSpec;
            String oldName;
            if (!(node instanceof TestToolNameAware) || this.testToolDict.containsValue(oldName = (testSpec = (TestToolNameAware)((Object)node)).getTestToolName())) continue;
            if (!this.testToolDict.containsKey(oldName)) {
                LOG.warn("The testTool ({}) (for test specification {}) is unknown. Will skip this tool and not rename it.", (Object)oldName, (Object)node.getTitle());
                continue;
            }
            String newName = this.testToolDict.get(oldName);
            testSpec.setTestToolName(newName);
            switch (oldName) {
                case "xUnit": {
                    LOG.warn("TestSpecification {} used test parser xUnit, and has been upgraded to JUnit (Ant, Gradle). There is a possibility this is wrong and you require another xUnit variant. Please verify this is the correct test parser.", (Object)node.getTitle());
                    break;
                }
                case "JMeter": {
                    LOG.warn("TestSpecification {} used test parser jMeter, and has been upgraded to JMeter (CSV). There is a possibility this is wrong and you require JMeter (XML). Please verify this is the correct test parser.", (Object)node.getTitle());
                    break;
                }
            }
            this.repositoryService.update((ConfigurationItem[])new BaseTestSpecification[]{node});
        }
        return true;
    }

    private List<BaseTestSpecification> getAllTestSpecs() {
        Preconditions.checkNotNull((Object)this.repositoryService);
        SearchParameters query = new SearchParameters();
        query.setType(Type.valueOf(BaseTestSpecification.class));
        return this.repositoryService.listEntities(query);
    }
}

