/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class MapMessageBodyWriter
implements MessageBodyWriter<Map<String, Object>> {
    public boolean isWriteable(Class<?> aClass, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Map.class.isAssignableFrom(aClass);
    }

    public long getSize(Map<String, Object> stringObjectMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Map<String, Object> stringObjectMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ResteasyProviderFactory providers = ResteasyProviderFactory.getInstance();
        entityStream.write("{\n".getBytes(StandardCharsets.UTF_8));
        String separator = "";
        for (Map.Entry<String, Object> entry : stringObjectMap.entrySet()) {
            entityStream.write(separator.getBytes(StandardCharsets.UTF_8));
            String key = JSONObject.quote((String)entry.getKey()) + " : ";
            entityStream.write(key.getBytes(StandardCharsets.UTF_8));
            Object value = entry.getValue();
            if (value == null) {
                entityStream.write("\"\"".getBytes(StandardCharsets.UTF_8));
            } else if (value instanceof String) {
                entityStream.write(JSONObject.quote((String)((String)value)).getBytes(StandardCharsets.UTF_8));
            } else {
                MessageBodyWriter messageBodyWriter = providers.getMessageBodyWriter(value.getClass(), null, annotations, mediaType);
                if (messageBodyWriter == null) {
                    throw new IllegalArgumentException("Cannot map " + value.getClass());
                }
                messageBodyWriter.writeTo(value, value.getClass(), null, annotations, mediaType, httpHeaders, entityStream);
            }
            separator = ",\n";
        }
        entityStream.write("}\n".getBytes(StandardCharsets.UTF_8));
    }
}

