/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.api.internal;

import com.xebialabs.license.License;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xltest.api.v1.InfoController;
import com.xebialabs.xltest.domain.LicenseInfo;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/api/internal/license")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@NoCache
public class LicenseController {
    private static final Logger LOG = LoggerFactory.getLogger(InfoController.class);
    private final LicenseService licenseService;

    @Autowired
    public LicenseController(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @GET
    public Response getLicenseInfo() {
        LicenseInfo licenseInfo = new LicenseInfo();
        try {
            this.licenseService.validate();
            License license = this.licenseService.getLicense();
            if (license.isDummyLicense()) {
                licenseInfo.setLicense("BOOTSTRAP");
                licenseInfo.setLicensedTo("Installation Bootstrap License");
                return Response.status((Response.Status)Response.Status.PAYMENT_REQUIRED).entity((Object)licenseInfo).build();
            }
            licenseInfo.setLicense("OK");
            licenseInfo.setLicensedTo(license.getStringValue(LicenseProperty.LICENSED_TO));
        }
        catch (LicensePeriodExpiredException e) {
            LOG.debug("License is expired", (Throwable)e);
            licenseInfo.setLicense("EXPIRED");
        }
        catch (Exception e) {
            LOG.debug("Could not validate license", (Throwable)e);
            licenseInfo.setLicense("OTHER_INVALID");
        }
        return Response.ok((Object)licenseInfo).build();
    }

    @GET
    @Path(value="reload")
    public Response reload() {
        try {
            LOG.info("Reloading license");
            this.licenseService.reload();
            LOG.info("License reloaded");
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("License reload failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="daysValid")
    public Response daysValid() {
        int days = this.licenseService.getValidPeriod().getDays();
        if (days < 0) {
            return Response.status((int)402).build();
        }
        return Response.ok((Object)days).build();
    }
}

