/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.AcceptAllKeyValueFilter;

public class ValuesCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public ValuesCommand(Cache<K, V> cache, Set<Flag> flags) {
        this.setFlags(flags);
        this.cache = flags != null ? cache.getAdvancedCache().withFlags(flags.toArray(new Flag[flags.size()])) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitValuesCommand(ctx, this);
    }

    @Override
    public Collection<V> perform(InvocationContext ctx) throws Throwable {
        return new BackingValuesCollection<K, V>(this.cache);
    }

    public String toString() {
        return "ValuesCommand{cache=" + this.cache.getName() + '}';
    }

    private static class EntryToValueIterator<V>
    implements CloseableIterator<V> {
        private final CloseableIterator<CacheEntry<?, V>> iterator;

        public EntryToValueIterator(CloseableIterator<CacheEntry<?, V>> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public V next() {
            return ((CacheEntry)this.iterator.next()).getValue();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void close() {
            this.iterator.close();
        }
    }

    private static class BackingValuesCollection<K, V>
    extends AbstractCloseableIteratorCollection<V, K, V> {
        public BackingValuesCollection(Cache<K, V> cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<V> iterator() {
            return new EntryToValueIterator(this.cache.getAdvancedCache().filterEntries(AcceptAllKeyValueFilter.getInstance()).iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            try (CloseableIterator<V> it = this.iterator();){
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() > 0) {
                HashSet set = new HashSet(c);
                try (CloseableIterator<V> it = this.iterator();){
                    while (!set.isEmpty() && it.hasNext()) {
                        set.remove(it.next());
                    }
                }
                return set.isEmpty();
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            try (CloseableIterator<V> it = this.iterator();){
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
    }
}

