/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TFileWriter;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFiles {
    private static final Logger logger = LoggerFactory.getLogger(TFiles.class);

    public static ByteSource newByteSource(final TFile file) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return new TFileInputStream((File)file);
            }
        };
    }

    public static CharSource newCharSource(final TFile file, final CharsetDecoder decoder) {
        return new CharSource(){

            public Reader openStream() throws IOException {
                return new TFileReader(file, decoder);
            }
        };
    }

    public static ByteSink newByteSink(final TFile file) {
        return new ByteSink(){

            public OutputStream openStream() throws IOException {
                return new TFileOutputStream((File)file);
            }
        };
    }

    public static CharSink newCharSink(final TFile file, final boolean append, final CharsetEncoder encoder) {
        return new CharSink(){

            public Writer openStream() throws IOException {
                return new TFileWriter(file, append, encoder);
            }
        };
    }

    public static void umountQuietly(TFile file) {
        if (file == null) {
            return;
        }
        try {
            if (file.isArchive() && file.getEnclArchive() == null) {
                TVFS.umount((TFile)file);
            } else if (file.isArchive()) {
                logger.error("Trying to umount a non-top-level archive ({})", (Object)file);
            }
        }
        catch (FsSyncException e) {
            logger.error("Could not umount {}, continuing", (Object)file);
            logger.debug("Exception was: ", (Throwable)e);
        }
    }

    public static boolean isArchive(String path) {
        boolean bl;
        TFile file = null;
        try {
            file = new TFile(path);
            bl = file.isArchive();
        }
        catch (Throwable throwable) {
            TFiles.umountQuietly(file);
            throw throwable;
        }
        TFiles.umountQuietly(file);
        return bl;
    }
}

