/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.BaseWikitextPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SymbolicPage
extends BaseWikitextPage {
    public static final String PROPERTY_NAME = "SymbolicLinks";
    private final WikiPage realPage;

    public SymbolicPage(String name, WikiPage realPage, WikiPage parent) {
        super(name, parent);
        this.realPage = realPage;
    }

    public WikiPage getRealPage() {
        return this.realPage;
    }

    public boolean containsWikitext() {
        return this.realPage instanceof WikitextPage;
    }

    @Override
    public WikiPage addChildPage(String name) {
        return this.realPage.addChildPage(name);
    }

    @Override
    public boolean hasChildPage(String name) {
        return this.realPage.hasChildPage(name);
    }

    @Override
    public WikiPage getChildPage(String name) {
        WikiPage childPage = this.realPage.getChildPage(name);
        if (childPage != null) {
            childPage = new SymbolicPage(name, childPage, this);
        }
        return childPage;
    }

    @Override
    public void removeChildPage(String name) {
        this.realPage.removeChildPage(name);
    }

    @Override
    public List<WikiPage> getChildren() {
        List<WikiPage> children = this.realPage.getChildren();
        LinkedList<WikiPage> symChildren = new LinkedList<WikiPage>();
        for (WikiPage child : children) {
            symChildren.add(new SymbolicPage(child.getName(), child, this));
        }
        return symChildren;
    }

    @Override
    public PageData getData() {
        return this.realPage.getData();
    }

    @Override
    public Collection<VersionInfo> getVersions() {
        return this.realPage.getVersions();
    }

    @Override
    public WikiPage getVersion(String versionName) {
        return new SymbolicPage(this.getName(), this.realPage.getVersion(versionName), this.getParent());
    }

    @Override
    public VersionInfo commit(PageData data) {
        return this.realPage.commit(data);
    }

    @Override
    public String getVariable(String name) {
        if (this.containsWikitext()) {
            return super.getVariable(name);
        }
        return this.realPage.getVariable(name);
    }

    @Override
    public String getHtml() {
        if (this.containsWikitext()) {
            return super.getHtml();
        }
        return this.realPage.getHtml();
    }

    @Override
    public ParsingPage getParsingPage() {
        if (this.containsWikitext()) {
            return super.getParsingPage();
        }
        return null;
    }

    @Override
    public Symbol getSyntaxTree() {
        if (this.containsWikitext()) {
            return super.getSyntaxTree();
        }
        return Symbol.emptySymbol;
    }
}

