/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public abstract class BaseWikiPage
implements WikiPage {
    protected final String name;
    protected final WikiPage parent;

    public BaseWikiPage(String name, WikiPage parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl(this);
    }

    @Override
    public WikiPage getParent() {
        return this.parent == null ? this : this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.parent == null || this.parent == this;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    @Override
    public int compareTo(WikiPage other) {
        try {
            WikiPagePath path1 = this.getPageCrawler().getFullPath();
            WikiPagePath path2 = other.getPageCrawler().getFullPath();
            return path1.compareTo(path2);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WikiPage)) {
            return false;
        }
        try {
            WikiPagePath path1 = this.getPageCrawler().getFullPath();
            WikiPagePath path2 = ((WikiPage)other).getPageCrawler().getFullPath();
            return path1.equals(path2);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath().hashCode();
        }
        catch (Exception e) {
            return 0;
        }
    }
}

