/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimSymbol;
import fitnesse.slim.instructions.AssignInstruction;
import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TableCell;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.slim.CustomComparator;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.ComparatorUtil;
import fitnesse.testsystems.slim.tables.Disgracer;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SlimTable {
    private String tableName;
    private int instructionNumber = 0;
    private String fixtureName;
    private List<SlimTable> children = new LinkedList<SlimTable>();
    private SlimTable parent = null;
    private final SlimTestContext testContext;
    protected final Table table;
    protected String id;
    protected CustomComparatorRegistry customComparatorRegistry;
    private final Map<String, String> symbolsToStore = new HashMap<String, String>();

    public SlimTable(Table table, String id, SlimTestContext testContext) {
        this.id = id;
        this.table = table;
        this.testContext = testContext;
        this.tableName = this.getTableType() + "_" + id;
    }

    public SlimTable getParent() {
        return this.parent;
    }

    public void addChildTable(SlimTable slimtable, int row) {
        slimtable.id = this.id + "." + this.children.size();
        slimtable.tableName = this.makeInstructionTag(this.instructionNumber) + "/" + slimtable.tableName;
        ++this.instructionNumber;
        slimtable.parent = this;
        this.children.add(slimtable);
        Table parentTable = this.getTable();
        Table childTable = slimtable.getTable();
        parentTable.appendChildTable(row, childTable);
    }

    public String replaceSymbols(String s) {
        return new SymbolReplacer(s).replace();
    }

    public String replaceSymbolsWithFullExpansion(String s) {
        return new FullExpansionSymbolReplacer(s).replace();
    }

    protected abstract String getTableType();

    public abstract List<SlimAssertion> getAssertions() throws SyntaxError;

    protected String makeInstructionTag() {
        return this.makeInstructionTag(this.instructionNumber++);
    }

    protected String makeInstructionTag(int instructionNumber) {
        return String.format("%s_%d", this.tableName, instructionNumber);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSymbol(String variableName) {
        return this.testContext.getSymbol(variableName);
    }

    public void setSymbol(String variableName, String value) {
        this.setSymbol(variableName, value, false);
    }

    public void setSymbol(String variableName, String value, boolean toStore) {
        this.testContext.setSymbol(variableName, value);
        if (toStore) {
            this.symbolsToStore.put(variableName, value);
        }
    }

    public Map<String, String> getSymbolsToStore() {
        return this.symbolsToStore;
    }

    public Table getTable() {
        return this.table;
    }

    protected SlimAssertion constructFixture(String fixtureName) {
        return this.constructInstance(this.getTableName(), fixtureName, 0, 0);
    }

    public void setFixtureName(String name) {
        this.fixtureName = name;
    }

    protected String getFixtureName() {
        if (this.fixtureName == null) {
            String tableHeader = this.table.getCellContents(0, 0);
            this.fixtureName = this.getFixtureName(tableHeader);
        }
        return Disgracer.disgraceClassName(this.fixtureName);
    }

    protected String getFixtureName(String tableHeader) {
        if (!tableHeader.contains(":")) {
            return tableHeader;
        }
        return tableHeader.split(":")[1];
    }

    protected SlimAssertion constructInstance(String instanceName, String className, int classNameColumn, int row) {
        ConstructionExpectation expectation = new ConstructionExpectation(classNameColumn, row);
        return this.makeAssertion(new MakeInstruction(this.makeInstructionTag(), instanceName, className, this.gatherConstructorArgumentsStartingAt(classNameColumn + 1, row)), expectation);
    }

    protected final SlimAssertion makeAssertion(Instruction instruction, SlimExpectation expectation) {
        return new SlimAssertion(instruction, expectation);
    }

    protected Object[] gatherConstructorArgumentsStartingAt(int startingColumn, int row) {
        int columnCount = this.table.getColumnCountInRow(row);
        ArrayList<String> arguments = new ArrayList<String>();
        for (int col = startingColumn; col < columnCount; ++col) {
            arguments.add(this.table.getCellContents(col, row));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected Instruction callFunction(String instanceName, String functionName, Object ... args) {
        return new CallInstruction(this.makeInstructionTag(), instanceName, Disgracer.disgraceMethodName(functionName), args);
    }

    protected Instruction callAndAssign(String symbolName, String instanceName, String functionName, Object ... args) {
        return new CallAndAssignInstruction(this.makeInstructionTag(), symbolName, instanceName, Disgracer.disgraceMethodName(functionName), args);
    }

    protected Instruction assign(String symbolName, String value) {
        return new AssignInstruction(this.makeInstructionTag(), symbolName, value);
    }

    protected String ifSymbolAssignment(int col, int row) {
        String expected = this.table.getCellContents(col, row);
        return this.ifSymbolAssignment(expected);
    }

    protected String ifSymbolAssignment(String expected) {
        return SlimSymbol.isSymbolAssignment(expected);
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    protected List<List<String>> tableAsList() {
        ArrayList<List<String>> tableArgument = new ArrayList<List<String>>();
        int rows = this.table.getRowCount();
        for (int row = 1; row < rows; ++row) {
            tableArgument.add(this.tableRowAsList(row));
        }
        return tableArgument;
    }

    private List<String> tableRowAsList(int row) {
        ArrayList<String> rowList = new ArrayList<String>();
        int cols = this.table.getColumnCountInRow(row);
        for (int col = 0; col < cols; ++col) {
            rowList.add(this.table.getCellContents(col, row));
        }
        return rowList;
    }

    public List<SlimTable> getChildren() {
        return this.children;
    }

    public void setCustomComparatorRegistry(CustomComparatorRegistry customComparatorRegistry) {
        this.customComparatorRegistry = customComparatorRegistry;
    }

    class Comparator {
        private final String expression;
        private final String actual;
        private final String expected;
        private final Pattern simpleComparison = Pattern.compile("\\A\\s*_?\\s*(!?(?:(?:[<>]=?)|(?:[~]?=)))\\s*(-?\\d*\\.?\\d+)\\s*\\Z");
        private final Pattern range = Pattern.compile("\\A\\s*(-?\\d*\\.?\\d+)\\s*<(=?)\\s*_\\s*<(=?)\\s*(-?\\d*\\.?\\d+)\\s*\\Z");
        private Pattern regexPattern = Pattern.compile("\\s*=~/(.*)/");
        private Pattern customComparatorPattern = Pattern.compile("\\s*(\\w*):(.*)");
        private double v;
        private double arg1;
        private double arg2;
        public String operation;
        private String arg1Text;

        public Comparator(String actual, String expected) {
            this.expression = SlimTable.this.replaceSymbols(expected);
            this.actual = actual;
            this.expected = expected;
        }

        public Comparator(String expression, String actual, String expected) {
            this.expression = expression;
            this.actual = actual;
            this.expected = expected;
        }

        public boolean matches() {
            SlimTestResult testResult = this.evaluate();
            return testResult != null && testResult.getExecutionResult() == ExecutionResult.PASS;
        }

        public SlimTestResult evaluate() {
            SlimTestResult message = this.evaluateRegularExpressionIfPresent();
            if (message != null) {
                return message;
            }
            message = this.evaluateCustomComparatorIfPresent();
            if (message != null) {
                return message;
            }
            this.operation = this.matchSimpleComparison();
            if (this.operation != null) {
                return this.doSimpleComparison();
            }
            Matcher matcher = this.range.matcher(this.expression);
            if (matcher.matches() && this.canUnpackRange(matcher)) {
                return this.doRange(matcher);
            }
            return null;
        }

        private SlimTestResult evaluateCustomComparatorIfPresent() {
            String prefix;
            CustomComparator customComparator;
            SlimTestResult message = null;
            if (SlimTable.this.customComparatorRegistry == null) {
                return null;
            }
            Matcher customComparatorMatcher = this.customComparatorPattern.matcher(this.expression);
            if (customComparatorMatcher.matches() && (customComparator = SlimTable.this.customComparatorRegistry.getCustomComparatorForPrefix(prefix = customComparatorMatcher.group(1))) != null) {
                String expectedString = customComparatorMatcher.group(2);
                try {
                    message = customComparator.matches(this.actual, expectedString) ? SlimTestResult.pass(expectedString + " matches " + this.actual) : SlimTestResult.fail(expectedString + " doesn't match " + this.actual);
                }
                catch (Exception e) {
                    message = SlimTestResult.fail(expectedString + " doesn't match " + this.actual + ":\n" + e.getMessage());
                }
            }
            return message;
        }

        private SlimTestResult evaluateRegularExpressionIfPresent() {
            Matcher regexMatcher = this.regexPattern.matcher(this.expression);
            SlimTestResult message = null;
            if (regexMatcher.matches()) {
                String pattern = regexMatcher.group(1);
                message = this.evaluateRegularExpression(pattern);
            }
            return message;
        }

        private SlimTestResult evaluateRegularExpression(String pattern) {
            Matcher patternMatcher = Pattern.compile(pattern).matcher(this.actual);
            SlimTestResult message = patternMatcher.find() ? SlimTestResult.pass(String.format("/%s/ found in: %s", pattern, this.actual)) : SlimTestResult.fail(String.format("/%s/ not found in: %s", pattern, this.actual));
            return message;
        }

        private SlimTestResult doRange(Matcher matcher) {
            boolean closedLeft = matcher.group(2).equals("=");
            boolean closedRight = matcher.group(3).equals("=");
            boolean pass = this.arg1 < this.v && this.v < this.arg2 || closedLeft && this.arg1 == this.v || closedRight && this.arg2 == this.v;
            return this.rangeMessage(pass);
        }

        private SlimTestResult rangeMessage(boolean pass) {
            String[] fragments = this.expected.trim().replaceAll("( )+", " ").split("_");
            String message = String.format("%s%s%s", fragments[0], this.actual, fragments[1]);
            message = SlimTable.this.replaceSymbolsWithFullExpansion(message);
            return pass ? SlimTestResult.pass(message) : SlimTestResult.fail(message);
        }

        private boolean canUnpackRange(Matcher matcher) {
            try {
                this.arg1 = Double.parseDouble(matcher.group(1));
                this.arg2 = Double.parseDouble(matcher.group(4));
                this.v = Double.parseDouble(this.actual);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        private SlimTestResult doSimpleComparison() {
            if (this.operation.equals("<") || this.operation.equals("!>=")) {
                return this.simpleComparisonMessage(this.v < this.arg1);
            }
            if (this.operation.equals(">") || this.operation.equals("!<=")) {
                return this.simpleComparisonMessage(this.v > this.arg1);
            }
            if (this.operation.equals(">=") || this.operation.equals("!<")) {
                return this.simpleComparisonMessage(this.v >= this.arg1);
            }
            if (this.operation.equals("<=") || this.operation.equals("!>")) {
                return this.simpleComparisonMessage(this.v <= this.arg1);
            }
            if (this.operation.equals("!=")) {
                return this.simpleComparisonMessage(this.v != this.arg1);
            }
            if (this.operation.equals("=")) {
                return this.simpleComparisonMessage(this.v == this.arg1);
            }
            if (this.operation.equals("~=")) {
                return this.simpleComparisonMessage(ComparatorUtil.approximatelyEqual(this.arg1Text, this.actual));
            }
            if (this.operation.equals("!~=")) {
                return this.simpleComparisonMessage(!ComparatorUtil.approximatelyEqual(this.arg1Text, this.actual));
            }
            return null;
        }

        private SlimTestResult simpleComparisonMessage(boolean pass) {
            String message = String.format("%s%s", this.actual, this.expected.trim().replaceAll("( )+", " "));
            message = SlimTable.this.replaceSymbolsWithFullExpansion(message);
            return pass ? SlimTestResult.pass(message) : SlimTestResult.fail(message);
        }

        private String matchSimpleComparison() {
            Matcher matcher = this.simpleComparison.matcher(this.expression);
            if (matcher.matches()) {
                try {
                    this.v = Double.parseDouble(this.actual);
                    this.arg1Text = matcher.group(2);
                    this.arg1 = Double.parseDouble(this.arg1Text);
                    return matcher.group(1);
                }
                catch (NumberFormatException e1) {
                    return null;
                }
            }
            return null;
        }
    }

    class RejectedValueExpectation
    extends ReturnedValueExpectation {
        public RejectedValueExpectation(int col, int row) {
            super(col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            SlimTestResult testResult = super.createEvaluationMessage(actual, expected);
            if (testResult != null) {
                return testResult.negateTestResult();
            }
            return null;
        }
    }

    class ReturnedSymbolExpectation
    extends ReturnedValueExpectation {
        private String symbolName;
        private String assignToName;

        public ReturnedSymbolExpectation(int col, int row, String symbolName) {
            super(col, row);
            this.assignToName = null;
            this.symbolName = symbolName;
        }

        public ReturnedSymbolExpectation(int col, int row, String symbolName, String assignToName) {
            super(col, row);
            this.assignToName = null;
            this.symbolName = symbolName;
            this.assignToName = assignToName;
        }

        @Override
        public TestResult evaluateExpectation(Object returnValue) {
            String value = SlimTable.this.getSymbol(this.symbolName);
            return super.evaluateExpectation(value);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            if (this.assignToName != null) {
                SlimTable.this.setSymbol(this.assignToName, actual);
                return SlimTestResult.plain(String.format("$%s<-[%s]", this.assignToName, actual));
            }
            return super.createEvaluationMessage(actual, expected);
        }
    }

    class ReturnedValueExpectation
    extends RowExpectation {
        public ReturnedValueExpectation(int col, int row) {
            super(col, row, SlimTable.this.table.getCellContents(col, row));
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            SlimTestResult testResult;
            String replacedExpected = SlimTable.this.replaceSymbols(expected);
            if (actual == null) {
                testResult = SlimTestResult.fail("null", replacedExpected);
            } else if (actual.equals(replacedExpected)) {
                testResult = SlimTestResult.pass(this.announceBlank(SlimTable.this.replaceSymbolsWithFullExpansion(expected)));
            } else if (replacedExpected.isEmpty()) {
                testResult = SlimTestResult.ignore(actual);
            } else {
                testResult = new Comparator(replacedExpected, actual, expected).evaluate();
                if (testResult == null) {
                    testResult = SlimTestResult.fail(actual, SlimTable.this.replaceSymbolsWithFullExpansion(expected));
                }
            }
            return testResult;
        }

        private String announceBlank(String originalValue) {
            return originalValue.isEmpty() ? "BLANK" : originalValue;
        }
    }

    class SymbolAssignmentExpectation
    extends RowExpectation {
        private String symbolName;

        SymbolAssignmentExpectation(String symbolName, int col, int row) {
            super(col, row);
            this.symbolName = symbolName;
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            SlimTable.this.setSymbol(this.symbolName, actual);
            return SlimTestResult.plain(String.format("$%s<-[%s]", this.symbolName, actual));
        }
    }

    class ConstructionExpectation
    extends RowExpectation {
        public ConstructionExpectation(int col, int row) {
            super(col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            if ("OK".equalsIgnoreCase(actual)) {
                return SlimTestResult.ok(SlimTable.this.replaceSymbolsWithFullExpansion(expected));
            }
            return SlimTestResult.error("Unknown construction message", actual);
        }
    }

    class SilentReturnExpectation
    implements SlimExpectation {
        private final int col;
        private final int row;

        public SilentReturnExpectation(int col, int row) {
            this.col = col;
            this.row = row;
        }

        @Override
        public TestResult evaluateExpectation(Object returnValue) {
            return null;
        }

        @Override
        public SlimExceptionResult evaluateException(SlimExceptionResult exceptionResult) {
            if (exceptionResult.isNoMethodInClassException() || exceptionResult.isNoInstanceException()) {
                return null;
            }
            SlimTable.this.table.updateContent(this.col, this.row, exceptionResult);
            SlimTable.this.getTestContext().incrementErroredTestsCount();
            return exceptionResult;
        }
    }

    class VoidReturnExpectation
    extends RowExpectation {
        public VoidReturnExpectation(int col, int row) {
            super(col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            SlimTable.this.table.substitute(this.getCol(), this.getRow(), SlimTable.this.replaceSymbolsWithFullExpansion(expected));
            return SlimTestResult.plain();
        }
    }

    class FullExpansionSymbolReplacer
    extends SymbolReplacer {
        FullExpansionSymbolReplacer(String s) {
            super(s);
        }

        @Override
        protected String formatSymbolValue(String name, String value) {
            return String.format("$%s->[%s]", name, value);
        }
    }

    class SymbolReplacer
    extends SlimSymbol {
        private String toReplace;

        public SymbolReplacer(String s) {
            this.toReplace = s;
        }

        @Override
        protected String getSymbolValue(String symbolName) {
            String value = SlimTable.this.getSymbol(symbolName);
            if (value == null) {
                for (int i = symbolName.length() - 1; i > 0; --i) {
                    String str = symbolName.substring(0, i);
                    value = SlimTable.this.getSymbol(str);
                    if (value == null) continue;
                    return value + symbolName.substring(i, symbolName.length());
                }
                return null;
            }
            return value;
        }

        public String replace() {
            return this.replace(this.toReplace);
        }
    }

    public abstract class RowExpectation
    implements SlimExpectation,
    TableCell {
        private final int col;
        private final int row;
        private final String originalContent;

        public RowExpectation(int col, int row) {
            this(col, row, col >= 0 ? slimTable.table.getCellContents(col, row) : null);
        }

        public RowExpectation(int col, int row, String originalContent) {
            this.row = row;
            this.col = col;
            this.originalContent = originalContent;
        }

        @Override
        public TestResult evaluateExpectation(Object returnValue) {
            SlimTestResult testResult;
            if (returnValue == null) {
                testResult = SlimTestResult.testNotRun();
            } else {
                String value = returnValue.toString();
                testResult = this.evaluationMessage(value, this.originalContent);
            }
            if (testResult != null) {
                SlimTable.this.table.updateContent(this.col, this.row, testResult);
                if (testResult.doesCount()) {
                    SlimTable.this.getTestContext().increment(testResult.getExecutionResult());
                }
            }
            return testResult;
        }

        SlimTestResult evaluationMessage(String actual, String expected) {
            return this.createEvaluationMessage(actual, expected);
        }

        protected abstract SlimTestResult createEvaluationMessage(String var1, String var2);

        @Override
        public SlimExceptionResult evaluateException(SlimExceptionResult exceptionResult) {
            SlimTable.this.table.updateContent(this.col, this.row, exceptionResult);
            SlimTable.this.getTestContext().incrementErroredTestsCount();
            return exceptionResult;
        }

        @Override
        public int getCol() {
            return this.col;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        public String getExpected() {
            return this.originalContent;
        }
    }
}

