/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SlimTestContextImpl
implements SlimTestContext {
    private final Map<String, String> symbols = new HashMap<String, String>();
    private final Map<String, ScenarioTable> scenarios = new HashMap<String, ScenarioTable>();
    private final TestSummary testSummary = new TestSummary();
    private final TestPage pageToTest;

    public SlimTestContextImpl(TestPage pageToTest) {
        this.pageToTest = pageToTest;
    }

    @Override
    public String getSymbol(String symbolName) {
        return this.symbols.get(symbolName);
    }

    @Override
    public void setSymbol(String symbolName, String value) {
        this.symbols.put(symbolName, value);
    }

    @Override
    public void addScenario(String scenarioName, ScenarioTable scenarioTable) {
        this.scenarios.put(scenarioName, scenarioTable);
    }

    @Override
    public ScenarioTable getScenario(String scenarioName) {
        return this.scenarios.get(scenarioName);
    }

    @Override
    public Collection<ScenarioTable> getScenarios() {
        return this.scenarios.values();
    }

    @Override
    public void incrementPassedTestsCount() {
        this.increment(ExecutionResult.PASS);
    }

    @Override
    public void incrementFailedTestsCount() {
        this.increment(ExecutionResult.FAIL);
    }

    @Override
    public void incrementErroredTestsCount() {
        this.increment(ExecutionResult.ERROR);
    }

    @Override
    public void incrementIgnoredTestsCount() {
        this.increment(ExecutionResult.IGNORE);
    }

    @Override
    public void increment(ExecutionResult result) {
        this.testSummary.add(result);
    }

    @Override
    public void increment(TestSummary testSummary) {
        this.testSummary.add(testSummary);
    }

    public TestSummary getTestSummary() {
        return this.testSummary;
    }

    @Override
    public TestPage getPageToTest() {
        return this.pageToTest;
    }
}

